% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{plotHistogramDistributionStoppingTimes}
\alias{plotHistogramDistributionStoppingTimes}
\title{Plots the Histogram of Stopping Times}
\usage{
plotHistogramDistributionStoppingTimes(
  safeSim,
  nPlan,
  deltaTrue,
  showOnlyNRejected = FALSE,
  nBin = 25L,
  ...
)
}
\arguments{
\item{safeSim}{A safeSim object, returned from \code{\link{replicateTTests}}.}

\item{nPlan}{numeric > 0, the planned sample size(s).}

\item{deltaTrue}{numeric, that represents the true underlying standardised effect size delta.}

\item{showOnlyNRejected}{logical, when \code{TRUE} discards the cases that did not reject.}

\item{nBin}{numeric > 0, the minimum number of bins in the histogram.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
a histogram object, and called for its side-effect to plot the histogram.
}
\description{
Helper function to display the histogram of stopping times.
}
\examples{
# Design safe test
alpha <- 0.05
beta <- 0.20
designObj <- designSafeT(1, alpha=alpha, beta=beta)

# Design frequentist test
freqObj <- designFreqT(1, alpha=alpha, beta=beta)

# Simulate under the alternative with deltaTrue=deltaMin
simResults <- replicateTTests(nPlan=designObj$nPlan, deltaTrue=1, parameter=designObj$parameter,
nPlanFreq=freqObj$nPlan)

plotHistogramDistributionStoppingTimes(
  simResults$safeSim, nPlan = simResults$nPlan,
  deltaTrue = simResults$deltaTrue)
}
