% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{sampleStoppingTimesSafeZ}
\alias{sampleStoppingTimesSafeZ}
\title{Simulate stopping times for the safe z-test}
\usage{
sampleStoppingTimesSafeZ(
  meanDiffMin,
  alpha = 0.05,
  alternative = c("two.sided", "less", "greater"),
  sigma = 1,
  kappa = sigma,
  nSim = 1000L,
  nMax = 1000,
  ratio = 1,
  testType = c("oneSample", "paired", "twoSample"),
  parameter = NULL,
  wantEValuesAtNMax = FALSE,
  pb = TRUE
)
}
\arguments{
\item{meanDiffMin}{numeric that defines the minimal relevant mean difference, the smallest population mean
that we would like to detect.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "two.sided" (default),
"greater" or "less".}

\item{sigma}{numeric > 0 representing the assumed population standard deviation used for the test.}

\item{kappa}{the true population standard deviation. Default kappa=sigma.}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of samples paths
for the safe z test under continuous monitoring.}

\item{nMax}{integer > 0, maximum sample size of the (first) sample in each sample path.}

\item{ratio}{numeric > 0 representing the randomisation ratio of condition 2 over condition 1. If testType
is not equal to "twoSample", or if nPlan is of length(1) then ratio=1.}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}

\item{wantEValuesAtNMax}{logical. If \code{TRUE} then compute eValues at nMax. Default \code{FALSE}.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}
}
\value{
a list with stoppingTimes and breakVector. Entries of breakVector are 0, 1. A 1 represents stopping
due to exceeding nMax, and 0 due to 1/alpha threshold crossing, which implies that in corresponding stopping
time is Inf.
}
\description{
Simulate stopping times for the safe z-test
}
\examples{
sampleStoppingTimesSafeZ(0.7, nSim=10)
}
