% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dotchart3}
\alias{dotchart3}
\title{Dotchart de Cleveland améliorés (Enhanced Cleveland's dotchart)}
\usage{
dotchart3(
  x,
  labels = NULL,
  groups = NULL,
  gdata = NULL,
  cex = par("cex"),
  pch = 21,
  gpch = 21,
  bg = par("bg"),
  color = par("fg"),
  gcolor = par("fg"),
  lcolor = "gray",
  xlim = range(x[is.finite(x)]),
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  cex.axis = cex,
  ...
)
}
\arguments{
\item{x}{soit un tableau ou une matrice de valeurs numériques (les \code{NA} sont autorisées). Si \code{x} est une matrice, le tracé global est constitué de points juxtaposés pour chaque ligne. Les entrées qui satisfont \code{is.numeric(x)} mais pas \code{is.vector(x) || is.matrix(x)} sont converties par \code{as.numeric}, avec un avertissement.}

\item{labels}{un vecteur d'étiquettes pour chaque point. Pour les vecteurs, la valeur par défaut est d'utiliser \code{names(x)} et pour les matrices, les étiquettes de ligne \code{dimnames(x)[[1]]}.}

\item{groups}{un facteur optionnel indiquant comment les éléments de \code{x} sont regroupés. Si \code{x} est une matrice, les groupes seront formés par défaut par les colonnes de \code{x}.}

\item{gdata}{les valeurs des données pour les groupes. Il s'agit généralement d'un résumé tel que la médiane ou la moyenne de chaque groupe.}

\item{cex}{la taille des caractères à utiliser. Fixer \code{cex} à une valeur inférieure à un peut être un moyen utile d'éviter le chevauchement des étiquettes. Contrairement à de nombreuses autres fonctions graphiques, cette fonction définit la taille réelle, et non un multiple de \code{par("cex")}.}

\item{pch}{le caractère ou le symbole de traçage à utiliser.}

\item{gpch}{le caractère ou le symbole de tracé à utiliser pour les valeurs de groupe.}

\item{bg}{la couleur de fond des caractères ou symboles à utiliser pour le tracé ; utilisez \verb{par(bg= *)} pour définir la couleur de fond de l'ensemble du tracé.}

\item{color}{la (les) couleur(s) à utiliser pour les points et les étiquettes.}

\item{gcolor}{la couleur unique à utiliser pour les étiquettes et les valeurs de groupe.}

\item{lcolor}{la (les) couleur(s) à utiliser pour les lignes horizontales.}

\item{xlim}{largeur horizontale de la zone de tracé, voir \code{plot.window}, par exemple.}

\item{main}{titre général du graphique, voir \code{title}.}

\item{xlab}{les annotations de l'axe des abscisses définies comme dans \code{title}.}

\item{ylab}{les annotations de l'axe des ordonnées définies comme dans \code{title}.}

\item{cex.axis}{la taille des caractères à utiliser pour les annotations des axes.}

\item{...}{les paramètres graphiques peuvent également être spécifiés comme arguments.}
}
\value{
Un dotplot de la série statistique.
}
\description{
dotchart3 est une version améliorée des fonctions dotchart et dotchart2 qui permettent de construire des diagrammes à points de Cleveland.
}
\examples{
data(Total_Secteur)
NameX <- Total_Secteur$NameX
Effectif <- Total_Secteur$Effectif
dotchart3(Effectif,labels=NameX,pch=19,col="#00FFFF",cex=1.6,cex.axis=1.2)
dotchart3(Effectif,labels=NameX,pch=19,col="#00FFFF")

}
\references{
F. Bertrand, Ch. Derquenne, G. Dufrénot, F. Jawadi and M. Maumy, C. Borsenberger editor, \emph{Statistiques pour l’économie et la gestion}, De Boeck Supérieur, Louvain-la-Neuve, 2021.
}
\seealso{
Other plot functions: 
\code{\link{plotcdf3}()}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@utt.fr}
}
\concept{plot functions}
