#' Population du Canada par provinces et territoires en 2020
#'
#' Répartition de la population des provinces et des territoires du Canada en 2020. Statistique Canada. Tableau 17-10-0005-01  Estimations de la population au 1er juillet, par âge et sexe.
#'
#' @name Proter_Canada
#' @docType data
#' @format A data frame with 13 observations on the following 2 variables.
#' \describe{
#' \item{ProTer}{a character vector}
#' \item{Population}{a numeric vector}
#' }
#' @references \doi{10.25318/1710000501-fra}
#' @keywords datasets
#' @examples
#'
#' data(Proter_Canada)
#' str(Proter_Canada)
#' barplot(Proter_Canada$Population, names.arg=Proter_Canada$ProTer, las=2)
#'
"Proter_Canada"
#> [1] "Proter_Canada"

#' @title Emploi par niveau d’études et taux d’emploi par groupe d’âge
#'
#' @description Les colonnes 2, 3 et 4 du tableau 2.8 contiennent les taux d’emploi, au troisième trimestre 2020, selon le
#' niveau d’études : premier cycle du second degré (PCSD), deuxième cycle du second degré (DCSD), supérieur
#' (SUP). Le taux d’emploi est le pourcentage d’actifs occupés dans la population en âge de travailler.
#' Les actifs occupés sont les personnes qui travaillent au moins une heure par semaine en tant que salarié ou à
#' titre lucratif, ou qui ont un emploi, mais sont temporairement absentes de leur travail pour maladie, congé ou
#' conflit social. Cet indicateur donne le pourcentage des actifs occupés âgés de 25 à 64 ans dans la population
#' des individus âgés de 25 à 64 ans. Les trois dernières colonnes du tableau 2.8 contiennent le taux d’emploi,
#' au troisième trimestre 2020, d’une classe d’âge. Cet indicateur se mesure en fonction du nombre des actifs
#' occupés d’un âge donné rapporté à l’effectif total de cette classe d’âge. Les actifs occupés sont les personnes
#' de 15 ans et plus qui, durant la semaine de référence, déclarent avoir effectué un travail rémunéré pendant
#' une heure au moins ou avoir occupé un emploi dont elles étaient absentes. Les taux d’emploi sont présentés
#' pour trois classes d’âge : les personnes âgées de 15 à 24 ans sont celles qui font leur entrée sur le marché
#' du travail à l’issue de leur scolarité, les personnes âgées de 25 à 54 ans sont celles qui sont au plus fort de
#' leur activité professionnelle, et les personnes âgées de 55 à 64 ans sont celles qui ont dépassé le pic de leur
#' carrière professionnelle et approchent de l’âge de la retraite. Cet indicateur est désaisonnalisé et est mesuré
#' en pourcentage de l’effectif total de la classe d’âge.
#'
#' @name Emploi_Etude_Age
#' @docType data
#' @format A data frame with 37 observations on the following 6 variables.
#' \describe{ \item{DCSD}{a numeric vector} \item{PCSD}{a
#' numeric vector} \item{SUP}{a numeric vector} \item{15_24}{a
#' numeric vector} \item{25_54}{a numeric vector}
#' \item{55_64}{a numeric vector} }
#' @references \doi{10.1787/6e3d44f3-fr}, \doi{10.1787/b01db125-fr}.
#' @keywords datasets
#' @examples
#'
#' data(Emploi_Etude_Age)
#' str(Emploi_Etude_Age)
#' plot(Emploi_Etude_Age)
#'
"Emploi_Etude_Age"
#> [1] "Emploi_Etude_Age"


#' Correction de copies
#'
#' Notes de deux correcteurs (A et B) pour les mêmes trente copies.
#'
#' @docType data
#' @format Un jeu de données avec 30 observations de 2 variables.
#' \describe{
#'   \item{Correcteur A}{}
#'   \item{Correcteur B}{}
#' }
#' @keywords datasets
"Copies"
#> [1] "Copies"

#' Prix de l'essence sans plomb 95
#'
#' Prix de l'essence sans plomb 95 en avril 2021 dans deux départements français, l'aube et la marne.
#'
#' @docType data
#' @format Un jeu de données avec 60 observations de 2 variables.
#' \describe{
#'   \item{Aube}{}
#'   \item{Marne}{}
#' }
#' @keywords datasets
"Essence"
#> [1] "Essence"

#' Résistance à l'éclatement
#'
#' Résistance à l'éclatement.
#'
#' @docType data
#' @format Un vecteur avec 30 observations.
#' @keywords datasets
"Resistance"
#> [1] "Resistance"

#' Flux bancaires
#'
#' Flux bancaires.
#'
#' @docType data
#' @format Un vecteur avec 30 observations.
#' @keywords datasets
"Flux"
#> [1] "Flux"

#' Précipitations aux USA en 1975
#'
#' Précipitations relevées dans soixante villes aux États-Unis d'Amérique en 1975.
#'
#' @docType data
#' @format Un jeu de données avec 60 observations de 4 variables.
#' \describe{
#'   \item{Ville}{}
#'   \item{Precipitation..inches.}{}
#'   \item{Precipitation..cms.}{}
#'   \item{Etat}{}
#' }
#' @keywords datasets
"Precipitations_USA"
#> [1] "Precipitations_USA"

#' Population du Canada par classes d'âge et provinces et territoires en 2020
#'
#' Répartition en classes d'âge de la population des provinces et des territoires du Canada en 2020. Statistique Canada. Tableau 17-10-0005-01  Estimations de la population au 1er juillet, par âge et sexe.
#'
#' @docType data
#' @format Un jeu de données avec 21 observations de 13 variables.
#' \describe{
#'   \item{Terre.Neuve.et.Labrador}{}
#'   \item{Île.du.Prince.Édouard}{}
#'   \item{Nouvelle.Écosse}{}
#'   \item{Nouveau.Brunswick}{}
#'   \item{Québec}{}
#'   \item{Ontario}{}
#'   \item{Manitoba}{}
#'   \item{Saskatchewan}{}
#'   \item{Alberta}{}
#'   \item{Colombie.Britannique}{}
#'   \item{Yukon}{}
#'   \item{TerritoiresduNord.Ouest}{}
#'   \item{Nunavut}{}
#' }
#' @references \doi{10.25318/1710000501-fra}
#' @keywords datasets
"AgevsProter_Canada_full"
#> [1] "AgevsProter_Canada_full"

#' Population du Canada par classes d'âge et sexe en 2020
#'
#' Répartition en classes d'âge et sexe de la population du Canada en 2020. Statistique Canada. Tableau 17-10-0005-01  Estimations de la population au 1er juillet, par âge et sexe.
#'
#' @docType data
#' @format Un jeu de données avec 21 observations de 2 variables.
#' \describe{
#'   \item{Hommes}{}
#'   \item{Femmes}{}
#' }
#' @references \doi{10.25318/1710000501-fra}
#' @keywords datasets
"AgevsSexe_Canada_full"
#> [1] "AgevsSexe_Canada_full"

#' Taux d'emploi en % de la classe d'age
#'
#' Le taux d'emploi d'une classe d'âge se mesure en fonction du nombre des actifs occupés d'un âge donné rapporté à l'effectif total de cette classe d'âge. Les actifs occupés sont les personnes de 15 ans et plus qui, durant la semaine de référence, déclarent avoir effectué un travail rémunéré pendant une heure au moins ou avoir occupé un emploi dont elles étaient absentes. Les taux d'emploi sont présentés pour quatre classes d'âge : les personnes âgées de 15 à 64 ans (personnes en âge de travailler); les personnes âgées de 15 à 24 ans sont celles qui font leur entrée sur le marché du travail à l'issue de leur scolarité, les personnes âgées de 25 à 54 ans sont celles qui sont au plus fort de leur activité professionnelle, et les personnes âgées de 55 à 64 ans sont celles qui ont dépassé le pic de leur carrière professionnelle et approchent de l'âge de la retraite. Cet indicateur est désaisonnalisé et est mesuré en pourcentage de l'effectif total de la classe d'âge. OCDE (2021), Taux d'emploi par groupe d'âge (indicateur).
#'
#' @docType data
#' @format Un jeu de données avec 35 observations de 6 variables.
#' \describe{
#'   \item{Etats.membres}{}
#'   \item{Partiel_Ens}{}
#'   \item{Partiel_H}{}
#'   \item{Partiel_F}{}
#'   \item{Salariés}{}
#'   \item{NonSalariés}{}
#' }
#' @references \doi{10.1787/b01db125-fr}
#' @keywords datasets
"Europe"
#> [1] "Europe"

#' Personnes hospitalisées atteintes de la Covid 19 (21/02/2021)
#'
#' Répartition par région française du nombre de personnes hospitalisées et atteintes du Covid 19 le 21 février 2021.
#'
#' @docType data
#' @format Un jeu de données avec 19 observations de 12 variables.
#' \describe{
#'   \item{Région}{}
#'   \item{Tous.âges}{}
#'   \item{X0.9}{}
#'   \item{X11.19}{}
#'   \item{X20.29}{}
#'   \item{X30.39}{}
#'   \item{X40.49}{}
#'   \item{X50.59}{}
#'   \item{X60.69}{}
#'   \item{X70.79}{}
#'   \item{X80.89}{}
#'   \item{X90.}{}
#' }
#' @keywords datasets
"HospitFull"
#> [1] "HospitFull"

#' Prix de vente en fonction de la marque, format large ou dépilé
#'
#' Valeurs d'articles de qualité équivalente en fonction de leur marque.
#'
#' @docType data
#' @format Un jeu de données avec 30 observations de 3 variables.
#' \describe{
#'   \item{Marque.1}{}
#'   \item{Marque.2}{}
#'   \item{Marque.3}{}
#' }
#' @keywords datasets
"Marque.Valeur.large"
#> [1] "Marque.Valeur.large"

#' Prix de vente en fonction de la marque, format long ou empilé
#'
#' Valeurs d'articles de qualité équivalente en fonction de leur marque.
#'
#' @docType data
#' @format Un jeu de données avec 90 observations de 2 variables.
#' \describe{
#'   \item{Marque}{}
#'   \item{Valeur}{}
#' }
#' @keywords datasets
"Marque.Valeur"
#> [1] "Marque.Valeur"

#' Nombre de personnes dans un foyer
#'
#' Ménages par taille du ménage en 2017, source INSEE.
#'
#' @docType data
#' @format Un jeu de données avec 6 observations de 2 variables `xi` et `ni`.
#' \describe{
#'   \item{xi}{Nombres de personnes dans un foyer}
#'   \item{ni}{Nombres de foyers}
#' }
#' @keywords datasets
"Personnes_Foyer"
#> [1] "Personnes_Foyer"

#' Population du Canada par classes d'âge et provinces et territoires en 2020
#'
#' Répartition en provinces et territoires et sexe de la population du Canada en 2020. Statistique Canada. Tableau 17-10-0005-01  Estimations de la population au 1er juillet, par âge et sexe.
#'
#' @docType data
#' @format Un jeu de données avec 13 observations de 2 variables.
#' \describe{
#'   \item{Hommes}{}
#'   \item{Femmes}{}
#' }
#' @references \doi{10.25318/1710000501-fra}
#' @keywords datasets
"ProtervsSexe_Canada"
#> [1] "ProtervsSexe_Canada"

#' Personnes en réanimation atteintes de la Covid 19 (21/02/2021)
#'
#' Répartition par région française du nombre de personne en réanimation et atteintes de la Covid 19 le 21 février 2021.
#'
#' @docType data
#' @format Un jeu de données avec 19 observations de 12 variables.
#' \describe{
#'   \item{Région}{}
#'   \item{Tous.âges}{}
#'   \item{X0.9}{}
#'   \item{X11.19}{}
#'   \item{X20.29}{}
#'   \item{X30.39}{}
#'   \item{X40.49}{}
#'   \item{X50.59}{}
#'   \item{X60.69}{}
#'   \item{X70.79}{}
#'   \item{X80.89}{}
#'   \item{X90.}{}
#' }
#' @keywords datasets
"ReaFull"
#> [1] "ReaFull"

#' Part du revenu national total équivalent	en Euro en 2019
#'
#' Répartitition du revenu par quantiles - enquêtes EU-SILC et PCM (ILC_DI01).
#'
#' @docType data
#' @format Un jeu de données avec 10 observations de 36 variables.
#' \describe{
#'   \item{"Déciles"}{}
#'   \item{"Belgique"}{}
#'   \item{"Bulgarie"}{}
#'   \item{"Tchéquie"}{}
#'   \item{"Danemark"}{}
#'   \item{"Allemagne..jusqu.en.1990..ancien.territoire.de.la.RFA."}{}
#'   \item{"Estonie"}{}
#'   \item{"Irlande"}{}
#'   \item{"Grèce"}{}
#'   \item{"Espagne"}{}
#'   \item{"France"}{}
#'   \item{"Croatie"}{}
#'   \item{"Italie"}{}
#'   \item{"Chypre"}{}
#'   \item{"Lettonie"}{}
#'   \item{"Lituanie"}{}
#'   \item{"Luxembourg"}{}
#'   \item{"Hongrie"}{}
#'   \item{"Malte"}{}
#'   \item{"Pays.Bas"}{}
#'   \item{"Autriche"}{}
#'   \item{"Pologne"}{}
#'   \item{"Portugal"}{}
#'   \item{"Roumanie"}{}
#'   \item{"Slovénie"}{}
#'   \item{"Slovaquie"}{}
#'   \item{"Finlande"}{}
#'   \item{"Suède"}{}
#'   \item{"Islande"}{}
#'   \item{"Norvège"}{}
#'   \item{"Suisse"}{}
#'   \item{"Royaume.Uni"}{}
#'   \item{"Monténégro"}{}
#'   \item{"Macédoine.du.Nord"}{}
#'   \item{"Serbie"}{}
#'   \item{"Turquie"}{}
#' }
#' @keywords datasets
"Richesse"
#> [1] "Richesse"

#' Emploi par secteur et par pays dans les pays de l'OCDE en 2020-Q3.
#'
#' Emploi par secteur d'activité et par pays (indicateur). OCDE (2021). \doi{10.1787/6b2fff89-fr}. (Consulté le 11 février 2021).
#' `INDUSCONSTR désigne l'activité industrielle *AVEC* la construction.
#'
#' @docType data
#' @format Un jeu de données avec 34 observations de 6 variables .
#' \describe{
#'   \item{PAYS}{Nombres de personnes dans un foyer}
#'   \item{AGR}{Nombres de foyers}
#'   \item{CONSTR}{Nombres de foyers}
#'   \item{INDUSCONSTR}{Nombres de foyers}
#'   \item{MFG}{Nombres de foyers}
#'   \item{SERV}{Nombres de foyers}
#' }
#' @keywords datasets
"Secteur"
#> [1] "Secteur"

#' Nombre de sièges et de voix dans l'Union européenne
#'
#' Nombre de sièges et de voix dans l'Union européenne.
#'
#' @docType data
#' @format Un jeu de données avec 27 observations de 4 variables.
#' \describe{
#'   \item{Etats.Membres}{}
#'   \item{Date.entrée}{}
#'   \item{Sièges.au.parlement}{}
#'   \item{Voix.au.conseil}{}
#' }
#' @keywords datasets
"Sieges_Voix"
#> [1] "Sieges_Voix"

#' Emploi total par pays dans les pays de l'OCDE en 2020-Q3.
#'
#' Emploi total par pays (indicateur). OCDE (2021). \doi{10.1787/6b2fff89-fr}. (Consulté le 11 février 2021).
#'
#' @docType data
#' @format Un jeu de données avec 34 observations de 2 variables.
#' \describe{
#'   \item{NameX}{Acronyme du pays}
#'   \item{Effectif}{Nombres de personnes}
#' }
#' @keywords datasets
"Total_Pays"
#> [1] "Total_Pays"

#' Emploi total par secteur dans les pays de l'OCDE en 2020-Q3.
#'
#' Emploi total par secteur d'activité (indicateur). OCDE (2021). \doi{10.1787/6b2fff89-fr}. (Consulté le 11 février 2021).
#' L'industrie (`INDUSwithoutCONSTR`) désigne l'activité industrielle *SANS* la construction.
#'
#' @docType data
#' @format Un jeu de données avec 5 observations de 3 variables.
#' \describe{
#'   \item{Secteur}{Acronyme du secteur d'actvité}
#'   \item{NameX}{Nom du secteur d'actvité}
#'   \item{Effectif}{Nombres de personnes}
#' }
#' @keywords datasets
"Total_Secteur"
#> [1] "Total_Secteur"


#' @title Air pollution data
#'
#' @description Échantillon de 50 villes (individus) tirées aléatoirement sur la pollution de l'air aux États-Unis en 1960
#'
#' @name air_pollution
#' @docType data
#' @format A data frame with 50 observations on the following 15 variables.
#' \describe{
#' \item{CITY}{a factor with levels \code{AUGUSTA}
#' \code{AUSTIN} \code{BEAUMONT} \code{BOSTON} \code{BRIDGEPO} \code{CHARLEST}
#' \code{CHARLOTT} \code{CHATTANO} \code{CHICAGO} \code{CLEVELAN}
#' \code{COLUMBUS} \code{DALLAS} \code{DAYTON} \code{DENVER} \code{DES_MOIN}
#' \code{DETROIT} \code{EL_PASO} \code{FALL_RIV} \code{FLINT} \code{FORT_WOR}
#' \code{FRESNO} \code{GALVESTO} \code{HUNTINGT} \code{INDIANAP} \code{JACKSON}
#' \code{JERSEY_C} \code{JOHNSTOW} \code{KNOXVILL} \code{MACON} \code{MEMPHIS}
#' \code{MIAMI} \code{MILWAUKE} \code{MOBILE} \code{NASHVIL} \code{NORFOLK}
#' \code{OMAHA} \code{PHOENIX} \code{PROVIDEN} \code{READING} \code{ROCKFORD}
#' \code{SAVANNAH} \code{SEATTLE} \code{SIOUX_FA} \code{SOUTH_BE} \code{TOLEDO}
#' \code{TOPEKA} \code{WINSTON} \code{YORK} \code{YOUNGSTO}. Ville où les données ont été observées.}
#' \item{TMR}{a numeric vector. Taux de mortalité exprimé en 1/10000.}
#' \item{SMIN}{a numeric vector. Plus petite valeur des relevés réalisés deux fois par semaine de sulfate (micro-g/m3 multiplié par 10).}
#' \item{SMEAN}{a numeric vector. Moyenne arithmétique des relevés réalisés deux fois par semaine de sulfate (micro-g/m3 multiplié par 10).}
#' \item{SMAX}{a numeric vector. Plus grande valeur des relevés réalisés deux fois par semaine de sulfate (micro-g/m3 multiplié par 10).}
#' \item{PMIN}{a numeric vector. Plus petite valeur des relevés réalisés deux fois par semaine de particules suspendues dans l'air (micro-g/m3 multiplié par 10).}
#' \item{PMEAN}{a numeric vector. Moyenne arithmétique des relevés réalisés deux fois par semaine de particules suspendues dans l'air (micro-g/m3 multiplié par 10).}
#' \item{PMAX}{a numeric vector. Logarithme de la plus grande valeur des relevés réalisés deux fois par semaine de particules suspendues dans l'air (micro-g/m3 multiplié par 10).}
#' \item{PM2}{a numeric vector. Densité de la population par mile carré (multiplié par 0,1).}
#' \item{PERWH}{a numeric vector. Pourcentage de population blanche.}
#' \item{NONPOOR}{a numeric vector. Pourcentage de ménages avec un revenu au dessus du seuil de pauvreté.}
#' \item{GE65}{a numeric vector.  Pourcentage (multiplié par 10) de la population des 65 ans et plus.}
#' \item{LPOP}{a numeric vector. Logarithme (en base 10 et multiplié par 10) de la population.}
#' \item{l_pm2}{a numeric vector. Logarithme de la densité de la population par mile carré (multiplié par 0,1).}
#' \item{l_pmax}{a numeric vector. Logarithme de la plus grande valeur des relevés réalisés deux fois par semaine de particules suspendues dans l'air (micro-g/m3 multiplié par 10).}
#' }
#'
#' @keywords datasets
#' @examples
#'
#' data(air_pollution)
#' str(air_pollution)
#' library(ggplot2)
#' library(GGally)
#' GGally::ggpairs(air_pollution[,2:4],)
#'
"air_pollution"
#> [1] "air_pollution"


#' @title Résultats des élections présidentielles françaises de 2012
#'
#' @description Résultats par département au premier tour des élections présidentielles françaises de 2012.
#'
#' @name presid_2012
#' @docType data
#' @format A data frame with 96 observations on the following 13 variables.
#' \describe{
#' \item{departement}{a factor with levels \code{Ain}
#' \code{Aisne} \code{Allier} \code{Alpes-de-Haute-Provence}
#' \code{Alpes-Maritimes} \code{Ardèche} \code{Ardennes} \code{Ariège}
#' \code{Aube} \code{Aude} \code{Aveyron} \code{Bas-Rhin}
#' \code{Bouches-du-Rhône} \code{Calvados} \code{Cantal} \code{Charente}
#' \code{Charente-Maritime} \code{Cher} \code{Corrèze} \code{Corse-du-Sud}
#' \code{Côte-d'Or} \code{Côtes-d'Armor} \code{Creuse} \code{Deux-Sèvres}
#' \code{Dordogne} \code{Doubs} \code{Drôme} \code{Essonne} \code{Eure}
#' \code{Eure-et-Loir} \code{Finistère} \code{Gard} \code{Gers} \code{Gironde}
#' \code{Haut-Rhin} \code{Haute-Corse} \code{Haute-Garonne} \code{Haute-Loire}
#' \code{Haute-Marne} \code{Haute-Saône} \code{Haute-Savoie}
#' \code{Haute-Vienne} \code{Hautes-Alpes} \code{Hautes-Pyrénées}
#' \code{Hauts-de-Seine} \code{Hérault} \code{Ille-et-Vilaine} \code{Indre}
#' \code{Indre-et-Loire} \code{Isère} \code{Jura} \code{Landes}
#' \code{Loir-et-Cher} \code{Loire} \code{Loire-Atlantique} \code{Loiret}
#' \code{Lot} \code{Lot-et-Garonne} \code{Lozère} \code{Maine-et-Loire}
#' \code{Manche} \code{Marne} \code{Mayenne} \code{Meurthe-et-Moselle}
#' \code{Meuse} \code{Morbihan} \code{Moselle} \code{Nièvre} \code{Nord}
#' \code{Oise} \code{Orne} \code{Paris} \code{Pas-de-Calais} \code{Puy-de-Dôme}
#' \code{Pyrénées-Atlantiques} \code{Pyrénées-Orientales} \code{Rhône}
#' \code{Saône-et-Loire} \code{Sarthe} \code{Savoie} \code{Seine-et-Marne}
#' \code{Seine-Maritime} \code{Seine-Saint-Denis} \code{Somme} \code{Tarn}
#' \code{Tarn-et-Garonne} \code{Territoire_de_Belfort} \code{Val-dOise}
#' \code{Val-de-Marne} \code{Var} \code{Vaucluse} \code{Vendée} \code{Vienne}
#' \code{Vosges} \code{Yonne} \code{Yvelines}. Nom du département (métropole) où les suffrages ont été dénombrés.}
#' \item{abstentions_1}{a numeric vector. Abstentions du 1er tour.}
#' \item{blancs_ou_nuls_1}{a numeric vector. Bulletins blancs ou nuls au 1er tour.}
#' \item{bayrou}{a numeric vector. Candidat Bayrou.}
#' \item{hollande_1}{a numeric vector. Candidat Hollande au 1er tour.}
#' \item{cheminade}{a numeric vector. Candidat Cheminade.}
#' \item{melenchon}{a numeric vector. Candidat Mélenchon.}
#' \item{dupont_aignan}{a numeric vector. Candidat Dupont-Aignan.}
#' \item{sarkozy_1}{a numeric vector. Candidat Sarkozy au 1er tour.}
#' \item{poutou}{a numeric vector. Candidat Poutou.}
#' \item{joly}{a numeric vector. Candidate Joly.}
#' \item{le_pen}{a numeric vector. Candidate Le Pen.}
#' \item{arthaud}{a numeric vector. Candidate Arthaud.}
#' }
#' @keywords datasets
#' @examples
#'
#' data(presid_2012)
#' str(presid_2012)
#' plot(presid_2012)
#' library(vcd)
#' vcd::mosaic(t(as.table(as.matrix(presid_2012[1:5,-1]))),
#' rot_labels=c(0,90,0,0), just_labels  = "right")
#'
"presid_2012"
#> [1] "presid_2012"


#' @title Caractéristiques de champignons
#'
#' @description Caractéristiques de 1000 champignons.
#'
#' @name champignons
#' @docType data
#' @format A data frame with 1000 observations on the following 8 variables.
#' \describe{\item{num_champ}{a numeric vector. Numéro du champignon.}
#' \item{classes}{a factor with levels \code{comestible} \code{veneneux}. Classes.}
#' \item{couleur_chapeau}{a factor with levels \code{blanc} \code{gris} \code{jaune} \code{marron} \code{rouge}. Couleur du chapeau.}
#' \item{contusions}{a factor with levels \code{abime} \code{non}. Contusions.}
#' \item{odeur}{a factor with levels \code{amande} \code{anis} \code{apre} \code{inodore}. Odeur du champignon.}
#' \item{espacement_lamelle}{a factor with levels \code{ferme} \code{serre}. Espacement des lamelles.}
#' \item{couleur_tige_dessus}{a factor with levels \code{blanc} \code{gris} \code{rose}. Couleur du dessus de la tige.}
#' \item{habitat}{a factor with levels \code{foret} \code{pelouse} \code{prairies} \code{sentier} \code{urbain}. Habitat.}
#' }
#' @keywords datasets
#' @examples
#'
#' data(champignons)
#' str(champignons)
#' summary(champignons)
#'
"champignons"
#> [1] "champignons"

#' @title Consommation d'électricité
#'
#' @description Consommation d'électricité journalière en France de l'année 2003?
#'
#' @name conso_temp
#' @docType data
#' @format A data frame with 365 observations on the following 8 variables.
#' \describe{ \item{Date}{a factor with levels \code{01/01/2003}
#' \code{01/02/2003} \code{01/03/2003} \code{01/04/2003} \code{01/05/2003}
#' \code{01/06/2003} \code{01/07/2003} \code{01/08/2003} \code{01/09/2003}
#' \code{01/10/2003} \code{01/11/2003} \code{01/12/2003} \code{02/01/2003}
#' \code{02/02/2003} \code{02/03/2003} \code{02/04/2003} \code{02/05/2003}
#' \code{02/06/2003} \code{02/07/2003} \code{02/08/2003} \code{02/09/2003}
#' \code{02/10/2003} \code{02/11/2003} \code{02/12/2003} \code{03/01/2003}
#' \code{03/02/2003} \code{03/03/2003} \code{03/04/2003} \code{03/05/2003}
#' \code{03/06/2003} \code{03/07/2003} \code{03/08/2003} \code{03/09/2003}
#' \code{03/10/2003} \code{03/11/2003} \code{03/12/2003} \code{04/01/2003}
#' \code{04/02/2003} \code{04/03/2003} \code{04/04/2003} \code{04/05/2003}
#' \code{04/06/2003} \code{04/07/2003} \code{04/08/2003} \code{04/09/2003}
#' \code{04/10/2003} \code{04/11/2003} \code{04/12/2003} \code{05/01/2003}
#' \code{05/02/2003} \code{05/03/2003} \code{05/04/2003} \code{05/05/2003}
#' \code{05/06/2003} \code{05/07/2003} \code{05/08/2003} \code{05/09/2003}
#' \code{05/10/2003} \code{05/11/2003} \code{05/12/2003} \code{06/01/2003}
#' \code{06/02/2003} \code{06/03/2003} \code{06/04/2003} \code{06/05/2003}
#' \code{06/06/2003} \code{06/07/2003} \code{06/08/2003} \code{06/09/2003}
#' \code{06/10/2003} \code{06/11/2003} \code{06/12/2003} \code{07/01/2003}
#' \code{07/02/2003} \code{07/03/2003} \code{07/04/2003} \code{07/05/2003}
#' \code{07/06/2003} \code{07/07/2003} \code{07/08/2003} \code{07/09/2003}
#' \code{07/10/2003} \code{07/11/2003} \code{07/12/2003} \code{08/01/2003}
#' \code{08/02/2003} \code{08/03/2003} \code{08/04/2003} \code{08/05/2003}
#' \code{08/06/2003} \code{08/07/2003} \code{08/08/2003} \code{08/09/2003}
#' \code{08/10/2003} \code{08/11/2003} \code{08/12/2003} \code{09/01/2003}
#' \code{09/02/2003} \code{09/03/2003} \code{09/04/2003} \code{09/05/2003}
#' \code{09/06/2003} \code{09/07/2003} \code{09/08/2003} \code{09/09/2003}
#' \code{09/10/2003} \code{09/11/2003} \code{09/12/2003} \code{10/01/2003}
#' \code{10/02/2003} \code{10/03/2003} \code{10/04/2003} \code{10/05/2003}
#' \code{10/06/2003} \code{10/07/2003} \code{10/08/2003} \code{10/09/2003}
#' \code{10/10/2003} \code{10/11/2003} \code{10/12/2003} \code{11/01/2003}
#' \code{11/02/2003} \code{11/03/2003} \code{11/04/2003} \code{11/05/2003}
#' \code{11/06/2003} \code{11/07/2003} \code{11/08/2003} \code{11/09/2003}
#' \code{11/10/2003} \code{11/11/2003} \code{11/12/2003} \code{12/01/2003}
#' \code{12/02/2003} \code{12/03/2003} \code{12/04/2003} \code{12/05/2003}
#' \code{12/06/2003} \code{12/07/2003} \code{12/08/2003} \code{12/09/2003}
#' \code{12/10/2003} \code{12/11/2003} \code{12/12/2003} \code{13/01/2003}
#' \code{13/02/2003} \code{13/03/2003} \code{13/04/2003} \code{13/05/2003}
#' \code{13/06/2003} \code{13/07/2003} \code{13/08/2003} \code{13/09/2003}
#' \code{13/10/2003} \code{13/11/2003} \code{13/12/2003} \code{14/01/2003}
#' \code{14/02/2003} \code{14/03/2003} \code{14/04/2003} \code{14/05/2003}
#' \code{14/06/2003} \code{14/07/2003} \code{14/08/2003} \code{14/09/2003}
#' \code{14/10/2003} \code{14/11/2003} \code{14/12/2003} \code{15/01/2003}
#' \code{15/02/2003} \code{15/03/2003} \code{15/04/2003} \code{15/05/2003}
#' \code{15/06/2003} \code{15/07/2003} \code{15/08/2003} \code{15/09/2003}
#' \code{15/10/2003} \code{15/11/2003} \code{15/12/2003} \code{16/01/2003}
#' \code{16/02/2003} \code{16/03/2003} \code{16/04/2003} \code{16/05/2003}
#' \code{16/06/2003} \code{16/07/2003} \code{16/08/2003} \code{16/09/2003}
#' \code{16/10/2003} \code{16/11/2003} \code{16/12/2003} \code{17/01/2003}
#' \code{17/02/2003} \code{17/03/2003} \code{17/04/2003} \code{17/05/2003}
#' \code{17/06/2003} \code{17/07/2003} \code{17/08/2003} \code{17/09/2003}
#' \code{17/10/2003} \code{17/11/2003} \code{17/12/2003} \code{18/01/2003}
#' \code{18/02/2003} \code{18/03/2003} \code{18/04/2003} \code{18/05/2003}
#' \code{18/06/2003} \code{18/07/2003} \code{18/08/2003} \code{18/09/2003}
#' \code{18/10/2003} \code{18/11/2003} \code{18/12/2003} \code{19/01/2003}
#' \code{19/02/2003} \code{19/03/2003} \code{19/04/2003} \code{19/05/2003}
#' \code{19/06/2003} \code{19/07/2003} \code{19/08/2003} \code{19/09/2003}
#' \code{19/10/2003} \code{19/11/2003} \code{19/12/2003} \code{20/01/2003}
#' \code{20/02/2003} \code{20/03/2003} \code{20/04/2003} \code{20/05/2003}
#' \code{20/06/2003} \code{20/07/2003} \code{20/08/2003} \code{20/09/2003}
#' \code{20/10/2003} \code{20/11/2003} \code{20/12/2003} \code{21/01/2003}
#' \code{21/02/2003} \code{21/03/2003} \code{21/04/2003} \code{21/05/2003}
#' \code{21/06/2003} \code{21/07/2003} \code{21/08/2003} \code{21/09/2003}
#' \code{21/10/2003} \code{21/11/2003} \code{21/12/2003} \code{22/01/2003}
#' \code{22/02/2003} \code{22/03/2003} \code{22/04/2003} \code{22/05/2003}
#' \code{22/06/2003} \code{22/07/2003} \code{22/08/2003} \code{22/09/2003}
#' \code{22/10/2003} \code{22/11/2003} \code{22/12/2003} \code{23/01/2003}
#' \code{23/02/2003} \code{23/03/2003} \code{23/04/2003} \code{23/05/2003}
#' \code{23/06/2003} \code{23/07/2003} \code{23/08/2003} \code{23/09/2003}
#' \code{23/10/2003} \code{23/11/2003} \code{23/12/2003} \code{24/01/2003}
#' \code{24/02/2003} \code{24/03/2003} \code{24/04/2003} \code{24/05/2003}
#' \code{24/06/2003} \code{24/07/2003} \code{24/08/2003} \code{24/09/2003}
#' \code{24/10/2003} \code{24/11/2003} \code{24/12/2003} \code{25/01/2003}
#' \code{25/02/2003} \code{25/03/2003} \code{25/04/2003} \code{25/05/2003}
#' \code{25/06/2003} \code{25/07/2003} \code{25/08/2003} \code{25/09/2003}
#' \code{25/10/2003} \code{25/11/2003} \code{25/12/2003} \code{26/01/2003}
#' \code{26/02/2003} \code{26/03/2003} \code{26/04/2003} \code{26/05/2003}
#' \code{26/06/2003} \code{26/07/2003} \code{26/08/2003} \code{26/09/2003}
#' \code{26/10/2003} \code{26/11/2003} \code{26/12/2003} \code{27/01/2003}
#' \code{27/02/2003} \code{27/03/2003} \code{27/04/2003} \code{27/05/2003}
#' \code{27/06/2003} \code{27/07/2003} \code{27/08/2003} \code{27/09/2003}
#' \code{27/10/2003} \code{27/11/2003} \code{27/12/2003} \code{28/01/2003}
#' \code{28/02/2003} \code{28/03/2003} \code{28/04/2003} \code{28/05/2003}
#' \code{28/06/2003} \code{28/07/2003} \code{28/08/2003} \code{28/09/2003}
#' \code{28/10/2003} \code{28/11/2003} \code{28/12/2003} \code{29/01/2003}
#' \code{29/03/2003} \code{29/04/2003} \code{29/05/2003} \code{29/06/2003}
#' \code{29/07/2003} \code{29/08/2003} \code{29/09/2003} \code{29/10/2003}
#' \code{29/11/2003} \code{29/12/2003} \code{30/01/2003} \code{30/03/2003}
#' \code{30/04/2003} \code{30/05/2003} \code{30/06/2003} \code{30/07/2003}
#' \code{30/08/2003} \code{30/09/2003} \code{30/10/2003} \code{30/11/2003}
#' \code{30/12/2003} \code{31/01/2003} \code{31/03/2003} \code{31/05/2003}
#' \code{31/07/2003} \code{31/08/2003} \code{31/10/2003} \code{31/12/2003}. Date.}
#' \item{conso}{a numeric vector. Consommation d'électricité en MWH.}
#' \item{t}{a numeric vector. Numéro du jour.}
#' \item{nom_jour}{a factor with levels \code{Dimanche} \code{Jeudi}
#' \code{Lundi} \code{Mardi} \code{Mercredi} \code{Samedi} \code{Vendredi}. Nom du jour de la semaine.}
#' \item{mois}{a factor with levels \code{Août} \code{Avril}
#' \code{Décembre} \code{Février} \code{Janvier} \code{Juillet} \code{Juin}
#' \code{Mai} \code{Mars} \code{Novembre} \code{Octobre} \code{Septembre}. Nom du mois.}
#' \item{temp}{a numeric vector. Température en degrés Celsius.}
#' \item{ejp}{a numeric vector. Statut du jour EDF (spécial = 1 ; non spécial = 0).}
#' \item{ferie}{a factor with levels \code{non} \code{oui}. Statut du jour annuel (férié ou non).}
#' }
#' @keywords datasets
#' @examples
#'
#' data(conso_temp)
#' str(conso_temp)
#' plot(conso_temp$conso)
#'
"conso_temp"
#> [1] "conso_temp"

#' @title Prix journalier du Bitcoin du 31/12/2014 au 15/05/2018
#'
#' @description Les données décrivent l'évolution du prix journalier du Bitcoin sur la période du
#' 31/12/2014 au 15/05/2018. Les données sont publiques et disponibles sur le site de
#' Yahoo finance (https://fr.finance.yahoo.com/quote/BTC-EUR/history?p=BTC-EUR).
#'
#' @name bitcoin
#' @docType data
#' @format A data frame with 1233 observations on the following 2 variables.
#' \describe{
#' \item{Date}{a POSIXct}
#' \item{Bitcoin}{a numeric vector}
#' }
#' @source Yahoo finance (https://fr.finance.yahoo.com/quote/BTC-EUR/history?p=BTC-EUR)
#' @keywords datasets
#' @examples
#'
#' data(bitcoin)
#' str(bitcoin)
#' plot(bitcoin)
#'
"bitcoin"
#> [1] "bitcoin"

#' @title Évaluation du risque de défaut d'entreprises
#'
#' @description Les données de la base sont issues de Bloomberg. On s'intéresse au risque d'insolvabilité de 1060 entreprises cotées en bourse,
#' durant l'année 2018, et appartenant à divers secteurs d'activité. Cette problématique est importante pour les investisseurs sur les marchés de capitaux
#' internationaux qui prêtent aux entreprises, notamment en devenant actionnaires. L'information sur les risques financiers des entreprises est généralement
#' fournie par des agences de notation : S&P, Fitch et Moody's. Dans la base, nous retenons les notations attribuées par S&P aux entreprises.
#'
#' Elles portent sur une évaluation du risque de défaut (le fait que l'entreprise ayant emprunté des fonds se retrouve un jour en incapacité de rembourser),
#' et les notes vont de AAA à CCC-. La grille de notation est la suivante :
#' \describe{
#' \item{•}{AAA est la note la plus élevée et correspond à une sécurité maximale pour un investisseur qui détiendrait des parts dans l'entreprise concernée par la note. Le risque de défaut est quasiment nul ;}
#' \item{•}{AA+, AA et AA- correspondent à une sécurité haute ou bonne (le risque de défaut est faible) ;}
#' \item{•}{A+, A et A- correspondent à une qualité moyenne supérieure ;}
#' \item{•}{BBB+, BBB et BBB- à une qualité moyenne inférieure ;}
#' \item{•}{BB+, BB, \dots, B- est un ensemble de notes classant les actifs des entreprises dans la catégorie spéculative, c'est-à-dire suffisamment risquée de telle sorte que le détenteur des parts de l'entreprise peut s'attendre à un défaut avec une probabilité forte ;}
#' \item{•}{CCC+, CCC, CCC-, D est une dernière catégorie de notes qui correspond à des actifs pour lesquels le risque de défaut est très élevé.}
#' }
#'
#' Pour nos entreprises, les notes figurent dans la colonne du tableau 1 intitulée `SP` (dernière colonne).
#'
#' La variable `SP` est qualitative et polytomique (puisqu'elle peut prendre plus de deux modalités).
#' Pour la transformer en une variable quantitative dichotomique, nous allons supposer que les agences de notation veulent envoyer un signal clair aux investisseurs, en différenciant les entreprises qui sont en bonne santé des autres.
#' Pour ce faire, chaque fois que la note sera supérieure à BB+, nous attribuons la valeur 1 à l'observation (entreprises en bonne santé présentant un risque de défaut ou de défaillance faible).
#' Et pour toute note inférieure à BB+, nous attribuons la valeur 0 (entreprises en mauvaise santé présentant un risque de défaut élevé).
#' Nous appelons la nouvelle variable Risque. Notons que le critère utilisé ici est arbitraire et un autre découpage pourrait être retenu.
#' Voir les colonnes intitulées `Risque` et `Défaut`.
#'
#' La colonne `Défaut2` correspond à un autre classement des entreprises, en les hiérarchisant des plus performantes aux moins performantes:
#' \describe{
#' \item{1.-}{pour les entreprises ayant une notation comprise entre AAA et A- (de première qualité à qualité moyenne supérieure) ;}
#' \item{2.-}{pour les entreprises ayant une notation comprise entre BBB+ à BBB- (qualité moyenne inférieure) ;}
#' \item{3.-}{pour les entreprises ayant une notation comprise inférieure à BBB- (un investisseur achetant des actifs de ces entreprises.}
#' }                                                                        #'                                                                       devrait les considérées comme spéculatifs ou incorporant un risque de défaut élevé).
#'
#' Variables explicatives
#'
#' Dans la base de données, nous avons retenu des variables qui sont habituellement liées aux performances des entreprises :
#' \describe{
#' \item{•}{`Liquid` : un ratio de liquidité, mesuré par le rapport entre l'actif circulant et l'exigible à court terme. Cette variable capte le risque de liquidité, c'est-à-dire l'incapacité des entreprises à rembourser des dettes exigibles à court terme (moins d'un an).}
#' \item{•}{`ROE` : le ratio du résultat net sur les capitaux propres. C'est une mesure de la rentabilité des capitaux investis par les actionnaires de l'entreprise.}
#' \item{•}{`Marge` : la marge bénéficiaire nette en pourcentage, c'est-à-dire la part du chiffre d'affaires que l'entreprise conserve après paiement de ses frais d'exploitation, des remboursements d'intérêt et du paiement de ses impôts.}
#' \item{•}{`OPM` : la marge opérationnelle définie comme le ratio du résultat d'exploitation et du chiffre d'affaires.}
#' }
#' Il s'agit de mesurer la performance économique de l'entreprise et donc sa viabilité à moyen/long terme.

#' En plus de ces variables qui renseignent sur des indicateurs de fonctionnement de l'entreprise, il est important de s'intéresser à des éléments ayant un impact direct sur leurs dettes. Trois indicateurs sont retenus ici :
#' \describe{
#' \item{•}{`Benef` : le bénéfice avant intérêt, impôts et amortissement. Cette variable est un indicateur du profit de l'entreprise.}
#' \item{•}{`Net` : le ratio des dettes financières sur `Benef`. Il s'agit de mesurer la capacité d'une entreprise à rembourser ses dettes en utilisant ses profits.}
#' \item{•}{`Roul` : le besoin en fonds de roulement. Il s'agit de la somme à mettre de côté pour pouvoir payer ses charges.}
#' }
#' C'est un indicateur d'autonomie financière de l'entreprise.
#'
#' @name bilan
#' @docType data
#' @format A data frame with 1060 observations on the following 14 variables.
#' \describe{
#' \item{Entreprise}{a character vector. Nom de l'entreprise.}
#' \item{id}{a numeric vector. Identifiant de l'entreprise.}
#' \item{ROE}{a numeric vector. Le ratio du résultat net sur les capitaux propres. C'est une mesure de la rentabilité des capitaux investis par les actionnaires de l'entreprise.}
#' \item{OPM}{a numeric vector. La marge opérationnelle définie comme le ratio du résultat d'exploitation et du chiffre d'affaires.}
#' \item{Marge}{a numeric vector. La marge bénéficiaire nette en pourcentage, c'est-à-dire la part du chiffre d'affaires que l'entreprise conserve après paiement de ses frais d'exploitation, des remboursements d'intérêt et du paiement de ses impôts.}
#' \item{Net}{a numeric vector. Le ratio des dettes financières sur Benef. Il s'agit de mesurer la capacité d'une entreprise à rembourser ses dettes en utilisant ses profits.}
#' \item{Benef}{a numeric vector. Le bénéfice avant intérêt, impôts et amortissement. Cette variable est un indicateur du profit de l'entreprise.}
#' \item{Liquid}{a numeric vector. Un ratio de liquidité, mesuré par le rapport entre l'actif circulant et l'exigible à court terme. Cette variable capte le risque de liquidité, c'est-à-dire l'incapacité des entreprises à rembourser des dettes exigibles à court terme (moins d'un an).}
#' \item{Roul}{a numeric vector. Le besoin en fonds de roulement. Il s'agit de la somme à mettre de côté pour pouvoir payer ses charges. C'est un indicateur d'autonomie financière de l'entreprise.}
#' \item{SP...10}{a character vector. Notation S&P. }
#' \item{Risque}{a numeric vector. Risque de défaut transformé en variable binaire.}
#' \item{Défaut}{a character vector. Risque de défaut.}
#' \item{Défaut2}{a character vector. Un autre classement des entreprises, en les hiérarchisant des plus performantes aux moins performantes.}
#' \item{SP...14}{a character vector. Notation S&P.}
#' }
#' @source Bloomberg.
#' @keywords datasets
#' @examples
#'
#' data(bilan)
#' str(bilan)
#' plot(bilan)
#'
"bilan"
#> [1] "bilan"
