% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.R
\name{sf_describe_objects}
\alias{sf_describe_objects}
\title{SObject Basic Information}
\usage{
sf_describe_objects(object_names, api_type = c("SOAP", "REST"),
  control = list(...), ..., verbose = FALSE)
}
\arguments{
\item{object_names}{character; the name of one or more Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{control}{\code{list}; a list of parameters for controlling the behavior of 
the API call being used. For more information of what parameters are available 
look at the documentation for \code{\link{sf_control}}}

\item{...}{arguments passed to \code{\link{sf_control}}}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{list}
}
\description{
Describes the individual metadata for the specified object.
}
\examples{
\dontrun{
account_metadata <- sf_describe_objects("Account")
account_metadata_SOAP <- sf_describe_objects("Account", api_type="SOAP")
multiple_objs_metadata <- sf_describe_objects(c("Contact", "Lead"))
}
}
