% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{sf_search}
\alias{sf_search}
\title{Perform SOSL Search}
\usage{
sf_search(
  search_string,
  is_sosl = FALSE,
  guess_types = TRUE,
  api_type = c("REST", "SOAP", "Bulk 1.0", "Bulk 2.0"),
  parameterized_search_options = list(...),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{search_string}{character; string to search using parameterized search 
or SOSL. Note that is_sosl must be set to TRUE and the string valid in order 
to perform a search using SOSL.}

\item{is_sosl}{logical; indicating whether or not to try the string as SOSL}

\item{guess_types}{logical; indicating whether or not to use \code{col_guess()} 
to try and cast the data returned in the query recordset. TRUE uses \code{col_guess()} 
and FALSE returns all values as character strings.}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{parameterized_search_options}{\code{list}; a list of parameters for 
controlling the search if not using SOSL. If using SOSL this argument is ignored.}

\item{verbose}{logical; do you want informative messages?}

\item{...}{arguments to be used to form the parameterized search options argument 
if it is not supplied directly.}
}
\value{
\code{tibble}
}
\description{
Searches for records in your organization’s data.
}
\examples{
\dontrun{
# free text search
area_code_search_string <- "(336)"
search_result <- sf_search(area_code_search_string)

# free text search with parameters
search_result <- sf_search(area_code_search_string,
                           fields_scope = "PHONE",
                           objects = "Lead",
                           fields = c("id", "phone", "firstname", "lastname"))

# using SOSL
my_sosl_search <- paste("FIND {(336)} in phone fields returning",
                        "contact(id, phone, firstname, lastname),",
                        "lead(id, phone, firstname, lastname)")
sosl_search_result <- sf_search(my_sosl_search, is_sosl=TRUE)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.soql_sosl.meta/soql_sosl/sforce_api_calls_sosl.htm}
}
