% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-query.R
\name{sf_query_result_bulk_v2}
\alias{sf_query_result_bulk_v2}
\title{Retrieve the results of a Bulk 2.0 query}
\usage{
sf_query_result_bulk_v2(
  job_id,
  guess_types = TRUE,
  bind_using_character_cols = FALSE,
  batch_size = 50000,
  locator = NULL,
  api_type = c("Bulk 2.0"),
  verbose = FALSE
)
}
\arguments{
\item{job_id}{\code{character}; the Salesforce Id assigned to a submitted job as
returned by \link{sf_create_job_bulk}. It will start with \code{"750"}.}

\item{guess_types}{\code{logical}; indicating whether or not to use \code{col_guess()}
to try and cast the data returned in the recordset. If \code{TRUE} then
\code{col_guess()} is used, if \code{FALSE} then all fields will be returned
as character. This is helpful when \code{col_guess()} will mangle field values
in Salesforce that you'd like to preserve during translation into a \code{tbl_df},
like numeric looking values that must be preserved as strings ("48.0").}

\item{bind_using_character_cols}{\code{logical}; an indicator of whether to
cast the data to all character columns to ensure that \code{\link[dplyr:bind]{bind_rows}}
does not fail because two paginated recordsets have differing datatypes for the
same column. Set this to \code{TRUE} rarely, typically only when having this
set to \code{FALSE} returns an error or you want all columns in the data to be
character.}

\item{batch_size}{\code{integer}; the number of individual records to be included in a
single batch uploaded to the Bulk APIs (1.0 or 2.0).}

\item{locator}{\code{character}; a string returned found in the API response
header of a prior iteration of \link{sf_query_result_bulk_v2} that is included
in the query string of the next call to paginate through all records returned
by the query.}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df}, formatted by Salesforce, containing query results
}
\description{
This function returns the row-level recordset of a Bulk 2.0 query
which has already been submitted as a Bulk 2.0 API job and has a JobComplete
state.
}
\examples{
\dontrun{
my_query <- "SELECT Id, Name FROM Account LIMIT 1000"
job_info <- sf_create_job_bulk(operation = 'query', object = 'Account', api_type="Bulk 2.0")
query_info <- sf_submit_query_bulk(job_id = job_info$id, soql = my_query, api_type="Bulk 2.0")
result <- sf_batch_details_bulk(job_id = query_info$jobId,
                                batch_id = query_info$id)
recordset <- sf_query_result_bulk(job_id = query_info$jobId,
                                  batch_id = query_info$id,
                                  result_id = result$result)
sf_close_job_bulk(job_info$id, api_type="Bulk 2.0")
}
}
\references{
\href{https://developer.salesforce.com/docs/atlas.en-us.api_bulk_v2.meta/api_bulk_v2/queries.htm}{Bulk 2.0 documentation}
}
