% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_Aliquot.R
\name{prepare_Aliquot}
\alias{prepare_Aliquot}
\title{Prepare Aliquots from Sample Dataset}
\usage{
prepare_Aliquot(sample, diameter, density = 0.65)
}
\arguments{
\item{sample}{\link{data.frame}, sample object to be distributed to
aliquots.}

\item{diameter}{\link{numeric} value, diameter of the aliquot sample
carriers in mm.}

\item{density}{\link{numeric} value, packing density of the grains on
the sample carrier. Default is \code{0.65}. The packing density is unitless.}
}
\value{
\link{list} of \link{data.frame} objects with grains organised as aliquots, i.e. list
elements.
}
\description{
The function consecutively fills aliquots (i.e., subsamples distributed on
round carrier discs) with grains from an input sample. Remaining grains that
are not enough to fill a further aliquot are discarded.
}
\examples{
## load example data set
data(sample, envir = environment())

A <- prepare_Aliquot(
 sample = sample, 
 diameter = 0.1)

B <- prepare_Aliquot(
 sample = sample, 
 diameter = 1, 
 density = 0.6)
 
}
\author{
Michael Dietze, GFZ Potsdam (Germany),
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
}
