% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks.R, R/chop.R
\name{brk_quantiles}
\alias{brk_quantiles}
\alias{chop_quantiles}
\alias{chop_deciles}
\alias{chop_equally}
\title{Chop by quantiles}
\usage{
brk_quantiles(probs, ...)

chop_quantiles(x, probs, ...)

chop_deciles(x, ...)

chop_equally(x, groups, ...)
}
\arguments{
\item{probs}{A vector of probabilities for the quantiles.}

\item{...}{Arguments passed to \code{\link[=quantile]{quantile()}}.}

\item{x}{A numeric vector.}

\item{groups}{Number of groups.}
}
\value{
For  \verb{chop_*} functions, a factor of the same length as \code{x}.
}
\description{
\code{chop_quantiles} chops data by quantiles. \code{chop_equally} chops
data into equal-sized groups. \code{chop_deciles} is a convenience shortcut and
chops into deciles.
}
\examples{
chop_quantiles(1:10, 1:3/4)

chop(1:10, brk_quantiles(1:3/4))

chop_deciles(1:10)

chop_equally(1:10, 5)

# to label by the quantiles themselves:
chop_quantiles(1:10, 1:3/4, lbl_intervals(raw = TRUE))

}
\seealso{
Other chopping functions: 
\code{\link{brk_mean_sd}()},
\code{\link{brk_n}()},
\code{\link{brk_width}()},
\code{\link{chop}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
