% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursStability.R
\name{getColoursStability}
\alias{getColoursStability}
\title{Gets colours for plotting snow stability indices}
\usage{
getColoursStability(
  Values,
  StabilityIndexThreshold = 0.77,
  StabilityIndexRange = c(0, 1),
  invers = FALSE,
  Resolution = 100
)
}
\arguments{
\item{Values}{Stability index values}

\item{StabilityIndexThreshold}{A scalar threshold that defines the transition from medium to poor stability.
The color scheme will be adjusted so that this threshold becomes apparent from the colours.}

\item{StabilityIndexRange}{The range the index spans, e.g. for TSA \verb{[0, 6]}, for RTA and p_unstable \verb{[0, 1]}, for critical crack length \verb{[0, 3]}, etc..}

\item{invers}{Indices like TSA/ RTA/ p_unstable increase the poorer layer stability gets. For indices with revers behaviour (e.g.,, critical crack length) switch this flag to \code{TRUE}.}

\item{Resolution}{Resolution of colour scale. Default is 100.}
}
\value{
Array with HTML colour codes
}
\description{
Gets colours for plotting snow stability indices in snowprofiles.
}
\examples{

p_unstable <- seq(0, 1, by=0.1)
plot(x = rep(1,length(p_unstable)), y = p_unstable,
     col = getColoursStability(p_unstable), pch = 19, cex = 3)

critical_crack_length <- c(seq(0.2, 0.8, by=0.1), 1.5, 2.5)
plot(x = rep(1,length(critical_crack_length)), y = critical_crack_length, pch = 19, cex = 3,
     col = getColoursStability(critical_crack_length, StabilityIndexThreshold = 0.4,
                               StabilityIndexRange = c(0, 3), invers = TRUE))

}
\seealso{
\link{getColoursGrainSize}, \link{getColoursGrainType}, \link{getColoursHardness}, \link{getColoursLWC}, \link{getColoursSnowTemp}, \link{getColoursPercentage}
}
\author{
fherla
}
