% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\docType{methods}
\name{crop}
\alias{crop}
\alias{crop,Satellite-method}
\title{Crop Satellite object}
\usage{
\S4method{crop}{Satellite}(x, y, subset = TRUE, snap = "near")
}
\arguments{
\item{x}{Satellite object.}

\item{y}{\code{\link{extent}} object.}

\item{subset}{Logical; if \code{TRUE} (default), all layers but the cropped 
ones are being dropped; if \code{FALSE}, cropped layers are appended to the 
Satellite object.}

\item{snap}{Direction towards which to align the extent as \code{character}. 
Available options are \code{"near"} (default), \code{"in"} and \code{"out"} 
(see \code{\link[raster]{alignExtent}}).}
}
\value{
A Satellite object consisting of cropped layers only. If 
\code{subset = FALSE}, a Satellite object with the cropped layers appended.
}
\description{
The function is a wrapper around the \code{\link{crop}} function to 
easily crop a Satellite object by an \code{\link{extent}} object.
}
\details{
Crop layers of a Satellite object to the size of a given 
\code{raster::extent} object.
}
\examples{
\dontrun{
## sample data
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC08*.TIF"), full.names = TRUE)
sat <- satellite(files)

## geographic extent of georg-gassmann-stadium (utm 32-n)
ext_ggs <- raster::extent(484015, 484143, 5627835, 5628020)

## crop satellite object by specified extent
sat_ggs <- crop(sat, ext_ggs)

plot(sat)
plot(sat_ggs)
}
}
\references{
Please refer to the respective functions for references.
}
\seealso{
This function is a wrapper for \code{raster::crop}.
}
