% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transf.R
\name{merge_tiles}
\alias{merge_tiles}
\alias{merge_tiles.satres}
\title{Merge objects that are tiles}
\usage{
merge_tiles(sr, ...)

\method{merge_tiles}{satres}(sr, ...)
}
\arguments{
\item{sr}{A \code{satres} object.}

\item{...}{\code{satres} objects.}
}
\value{
A \code{satres} object.
}
\description{
Merge objects whose bands are tiles of a mosaic.
}
\details{
The objects must have the same CRS, spatial resolution and bands.
}
\examples{

esa_f <- system.file("extdata", "esa/f", package = "satres")
esa_g <- system.file("extdata", "esa/g", package = "satres")
sr2 <- satres(dir = esa_f)
sr <- satres(dir = esa_g) |>
  merge_tiles(sr2)

}
\seealso{
\code{\link{satres}}

Other satellite transformation: 
\code{\link{clip_bands}()},
\code{\link{select_bands}()}
}
\concept{satellite transformation}
