% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{save_by_resolution}
\alias{save_by_resolution}
\alias{save_by_resolution.satres}
\title{Save multi-band rasters according to their spatial resolution}
\usage{
save_by_resolution(sr, out_dir, only_show_files)

\method{save_by_resolution}{satres}(sr, out_dir = NULL, only_show_files = FALSE)
}
\arguments{
\item{sr}{A \code{satres} object.}

\item{out_dir}{A string, output folder.}

\item{only_show_files}{A boolean, only show the files that would be created,
not create them.}
}
\value{
A vector of strings, name of the saved files.
}
\description{
Saves multi-band raster files of the object according to its spatial
resolution. The file names correspond to the resolution of each one.
}
\details{
They are stored in the folder that is indicated or, if none is indicated, in
the folder that was used to create the object.
}
\examples{

esa <- system.file("extdata", "esa", package = "satres")
sr <- satres(dir = esa)
f <- sr |>
     save_by_resolution(only_show_files = TRUE)

}
\seealso{
\code{\link{sat_untarzip}}

Other satellite exportation: 
\code{\link{as_SpatRaster}()}
}
\concept{satellite exportation}
