% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inc_prop.R
\name{inc_prop}
\alias{inc_prop}
\title{Computing the Incidence Proportion}
\usage{
inc_prop(data, tau)
}
\arguments{
\item{data}{(\code{data.frame})\cr with columns including:
\itemize{
\item \code{time_to_event}: Time to the first AE, death or soft competing
event.
\item \code{type_of_event}: 0 for censored, 1 for AE, 2 for death, 3 for soft
competing event.
}}

\item{tau}{(\code{numeric})\cr milestone at which incidence proportion is computed.}
}
\value{
(\code{vector})\cr with the following entries:
\itemize{
\item \code{ae_prob}: Estimated probability of AE.
\item \code{ae_prob_var}: Variance of that estimate.
}
}
\description{
Computing the Incidence Proportion
}
\examples{
set.seed(123)
dat <- generate_data(
  n = 5,
  cens = c(2, 5),
  haz_ae = 2,
  haz_death = 3,
  haz_soft = 5
)

inc_prop(dat, tau = 4)

}
