% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babble.R
\name{babble}
\alias{babble}
\title{Babble!}
\usage{
babble(model, input = NA, n_max = 100L, L = attr(model, "L"))
}
\arguments{
\item{model}{a \code{sbo_predictor} object.}

\item{input}{a length one character vector. Starting point for babbling!
If \code{NA}, as by default, a random word is sampled from the model's
dictionary.}

\item{n_max}{a length one integer. Maximum number of words to generate.}

\item{L}{a length one integer. Number of next-word suggestions from
which to sample (see details).}
}
\value{
A character vector of length one.
}
\description{
Generate random text based on Stupid Back-off language model.
}
\details{
This function generates random text from a Stupid Back-off language
model.
\code{babble} randomly samples one of the top L next word
predictions. Text generation stops when an End-Of-Sentence token is
encountered, or when the number of generated words exceeds n_max.
}
\examples{
# Babble!
p <- sbo_predictor(twitter_predtable)
set.seed(840) # Set seed for reproducibility
babble(p)
}
\author{
Valerio Gherardi
}
