% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_upload_files.R
\name{item_upload_create}
\alias{item_upload_create}
\title{#' Upload file(s) and create a new item}
\usage{
item_upload_create(parent_id, files, ..., session = current_session())
}
\arguments{
\item{parent_id}{An \code{\link{sbitem}} object or character ScienceBase ID corresponding to the 
parent item (folder)}

\item{files}{A string vector of paths to files to be uploaded}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
An object of class \code{sbitem}
}
\description{
Create a new item with files attached, all in one call to SB
}
\examples{
\dontrun{
# You'll need a parent id for a folder/item
## here, using your highest level parent folder
file <- system.file("examples", "books.json", package = "sbtools")
item_upload_create(user_id(), file)
}
}
