% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_get_fields.R
\name{item_get_fields}
\alias{item_get_fields}
\title{Retrieve specific fields from an SB item}
\usage{
item_get_fields(sb_id, fields, ..., drop = TRUE,
  session = current_session())
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{fields}{a vector of fields}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{drop}{logical. If only one field is selected, should the
list format be dropped?}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
List serialization of chosen metadata for an SB item
}
\description{
Retrieve specific fields from an SB item
}
\examples{
# Get certain fields from an item
item_get_fields("4f4e4b24e4b07f02db6aea14", c('title', 'citation', 'contacts'))

\dontrun{
# If only 1 field selection, do or don't drop list format
item_get_fields("4f4e4b24e4b07f02db6aea14", 'title')
item_get_fields("4f4e4b24e4b07f02db6aea14", 'title', drop = FALSE)
}
}
