% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_get.R
\name{item_get_fields}
\alias{item_get_fields}
\title{Retrieve specific fields from an SB item}
\usage{
item_get_fields(sb_id, fields, ..., drop = TRUE)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{fields}{a vector of fields}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}.}

\item{drop}{logical. If only one field is selected, should the
list format be dropped?}
}
\value{
List serialization of chosen metadata for an SB item
}
\description{
Retrieve specific fields from an SB item
}
\examples{
\donttest{
# Get certain fields from an item
item_get_fields("63cb38b2d34e06fef14f40ad", c('title', 'citation', 'contacts'))

#' # If only 1 field selection, do or don't drop list format
item_get_fields("63cb38b2d34e06fef14f40ad", 'title')
item_get_fields("63cb38b2d34e06fef14f40ad", 'title', drop = FALSE)
}
}
