% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_create.R
\name{folder_create}
\alias{folder_create}
\title{Create a folder}
\usage{
folder_create(parent_id = user_id(), name, ...)
}
\arguments{
\item{parent_id}{An \code{\link{sbitem}} object or character ScienceBase ID corresponding to the 
parent item (folder)}

\item{name}{(character) the folder name}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}}
}
\value{
A \code{\link[httr]{response}} object
}
\description{
Create a special kind of item on ScienceBase that is intended to be 
a "folder" that contains one or more child items. This is similar to 
a standard item (\code{\link{item_create}}) but defaults to showing 
child-items on the ScienceBase web interface.
}
\examples{
\dontrun{
folder_create(name="foobar345")
}
}
