% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object_Utilities.R
\name{Add_Cell_Complexity_Seurat}
\alias{Add_Cell_Complexity_Seurat}
\title{Add Cell Complexity Value}
\usage{
Add_Cell_Complexity_Seurat(
  seurat_object,
  meta_col_name = "log10GenesPerUMI",
  assay = "RNA",
  overwrite = FALSE
)
}
\arguments{
\item{seurat_object}{object name.}

\item{meta_col_name}{name to use for new meta data column.  Default is "log10GenesPerUMI".}

\item{assay}{assay to use in calculation.  Default is "RNA".  \emph{Note} This should only be changed if
storing corrected and uncorrected assays in same object (e.g. outputs of both Cell Ranger and Cell Bender).}

\item{overwrite}{Logical.  Whether to overwrite existing an meta.data column.  Default is FALSE meaning that
function will abort if column with name provided to \code{meta_col_name} is present in meta.data slot.}
}
\value{
A Seurat Object
}
\description{
Add measure of cell complexity/novelty (log10PerUMI) for data QC.
}
\examples{
library(Seurat)
pbmc_small <- Add_Cell_Complexity_Seurat(seurat_object = pbmc_small)

}
\concept{object_util}
