% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{makeGOSeurat}
\alias{makeGOSeurat}
\title{create a seurat object with GO terms}
\usage{
makeGOSeurat(ensembl_to_GO, seurat_obj, feature_type = "ensembl_gene_id")
}
\arguments{
\item{ensembl_to_GO}{ensembl_to_go mapping table from function ensemblToGo}

\item{seurat_obj}{count matrix with genes to cells}

\item{feature_type}{feature type of count matrix, choose from ensembl_gene_id, external_gene_name, default ensembl_gene_id}
}
\value{
a seurat object with GO terms as features
}
\description{
create a seurat object with GO terms
}
\examples{
\donttest{
library(scGOclust)
library(httr)
httr::set_config(httr::config(ssl_verifypeer = FALSE))
data(mmu_tbl)
data(mmu_subset)
makeGOSeurat(ensembl_to_GO = mmu_tbl,
 seurat_obj = mmu_subset,
 feature_type = "external_gene_name")
}
}
