% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_dataframe_to_output.R
\name{make_dataframe_to_output}
\alias{make_dataframe_to_output}
\title{Export a data frame to CSV, Word, or Excel}
\usage{
make_dataframe_to_output(x, filename = NULL, format = "csv")
}
\arguments{
\item{x}{A data frame to export}

\item{filename}{Optional. The file name (with or without path, without extension).
If not provided, the data frame name is used.}

\item{format}{Character. One of \code{"csv"}, \code{"docx"}, or \code{"excel"}. Default is \code{"csv"}.}
}
\value{
Invisible path to the generated file
}
\description{
This function writes a data frame to a user-specified file path in a user-specified format (CSV, Word, or Excel).
\itemize{
\item CSV uses \code{write.csv()}
\item Word (\code{docx}) uses \code{officer} and makes column names safe
\item Excel (\code{xlsx}) uses \code{openxlsx}
}
}
\examples{
\donttest{
df <- data.frame(x = 1:3, y = c("A", "B", "C"))

# Write to a temporary directory (CRAN-safe)
tmp_file <- file.path(tempdir(), "demo_csv")
make_dataframe_to_output(df, filename = tmp_file, format = "csv")
}
}
