% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_reviewNeurons.R
\name{reviewNeuronsInteractive}
\alias{reviewNeuronsInteractive}
\title{Manually classify the identified neurons from SCALPEL.}
\usage{
reviewNeuronsInteractive(scalpelOutput, neuronSet)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{neuronSet}{The set of neurons that should be reviewed:
use \code{"A"} for those resulting from \code{\link{scalpelStep2}} and saved as \code{scalpelOutput$A}, or use \code{"Afilter"} for those resulting from
\code{\link{scalpelStep3}} and saved as \code{scalpelOutput$Afilter}. This argument is ignored if the class of \code{scalpelOutput} is \code{scalpelStep2}.}
}
\value{
None
}
\description{
We interactively review the set of identified neurons that result from either Step 2 or 3 of SCALPEL in order to manually classify them according
to whether they appear to be real neurons or not. To do this, the frame from which the dictionary element was derived is plotted.
The user can manually classify the neuron as real or not, or indicate that additional frames are needed to make the classification, in which
case the \code{\link{reviewNeuronsMoreFrames}} function can subsequently be used. A similar manual classification can be done non-interactively using \code{\link{reviewNeurons}}.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function

#we review the set of spatial components from Step 2,
#which are contained in scalpelOutput$A
reviewNeuronsInteractive(scalpelOutput = scalpelOutput, neuronSet = "A")
#enter "Y" for the first neuron and then "Q"
#entering "Q" allows us to finish manually classifying later using the same command
#this time there are fewer left to review
reviewNeuronsInteractive(scalpelOutput = scalpelOutput, neuronSet = "A")
#enter "N" for the first and "?" for the second this time
#note that once a neuron is classified as "N", it disappears from the plot
}
}
\seealso{
For other functions useful in the classification process, see \code{\link{reviewNeuronsMoreFrames}},
\code{\link{reviewOverlappingNeurons}}, and \code{\link{updateNeuronsInteractive}}. Once classification is finished,
the argument \code{neuronsToOutline="kept"} can be used with \code{\link{plotBrightest}} and \code{\link{plotVideoVariance}},
and the argument \code{neuronsToDisplay="kept"} can be used with \code{\link{plotResults}}, \code{\link{plotResultsAllLambda}},
 \code{\link{plotTemporal}}, and \code{\link{plotSpatial}}. Finally, the argument \code{excludeReps="discarded"} allows
 the discarded dictionary elements to be excluded from the sparse group lasso model when running \code{\link{scalpelStep3}}.
}

