% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_helper.R
\name{getScalpelStep2}
\alias{getScalpelStep2}
\title{Read in results from Step 2 of SCALPEL.}
\usage{
getScalpelStep2(outputFolder, version = NULL, cutoff = 0.18, omega = 0.2)
}
\arguments{
\item{outputFolder}{The existing directory where the results that the user wishes to use are saved.}

\item{version}{The 5-digit folder ID for the results that the user wishes to load. If NULL, automatically chooses
the only version in outputFolder and if more than one version exists, returns an error.}

\item{cutoff}{A value in [0,1] indicating the dendrogram cutpoint used. The default value is 0.18.}

\item{omega}{A value in [0,1] indicating the dissimilarity metric weight used for clustering. The default value is 0.2.}
}
\value{
An object of class \code{scalpelStep2}, which can be used to run SCALPEL Step 3 using \code{\link{scalpelStep3}}
or can be used with the plotting functions \code{\link{plotCluster}} and \code{\link{plotSpatial}}.
}
\description{
This step allows the user to retrieve the object of class \code{scalpelStep2} for results from a previous session.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function
#folder where results were saved
outputFolder = "scalpelResults"

#read previous results in
#simplest example with default parameters:
out = getScalpelStep2(outputFolder = outputFolder)
#note: if Step 1 has been run more than once, will need to specify 'version'

#example with optional parameters:
#need to enter if non-default options were used
out = getScalpelStep2(outputFolder = outputFolder, omega = 0.2, cutoff = 0.18)
}
}
\seealso{
\code{\link{scalpelStep2}}, \code{\link{scalpel}}
}
