% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_graphics.R
\name{plotTemporal}
\alias{plotTemporal}
\title{Plot temporal components from Step 3 of SCALPEL.}
\usage{
plotTemporal(
  scalpelOutput,
  neuronsToDisplay = NULL,
  colVec = NULL,
  ylab = "",
  title = "",
  fileName = NULL,
  lambdaIndex = NULL
)
}
\arguments{
\item{scalpelOutput}{An object returned by one of these SCALPEL functions:
\code{\link{scalpel}} or \code{\link{scalpelStep3}}.}

\item{neuronsToDisplay}{Vector giving which neurons' temporal components to plot. The indices refer to which rows
of \code{scalpelOutput$Zhat} to plot. By default, all components are plotted. Users may also specify \code{"kept"},
which will exclude all dictionary elements discarded using a previous call to \code{\link{reviewNeurons}} or \code{\link{reviewNeuronsInteractive}}.}

\item{colVec}{Vector of colors to use, which are chosen automatically if the default value of NULL is used.}

\item{ylab}{Label for the y-axis.}

\item{title}{Label for the title.}

\item{fileName}{If provided, the plot will be saved to the specified location.}

\item{lambdaIndex}{Optional advanced user argument: Index of lambda value for which results will be plotted. Default is
to use lambda value of \code{scalpelOutput$lambda} but specifying this will use the lambda value of \code{scalpelOutput$lambdaSeq[lambdaIndex]}.}
}
\value{
None
}
\description{
We plot the temporal components, displaying the estimated fluorescence over time for each spatial component,
which result from running Step 3 of SCALPEL.
}
\details{
If \code{lambdaIndex} is \code{NULL}, each temporal component is scaled by its largest value. If
\code{lambdaIndex} is specified, each temporal component is scaled by its largest value across all of the lambda values.
Temporal components that were zeroed out in the sparse group lasso are omitted from the plot.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function

#simplest example with default parameters:
plotTemporal(scalpelOutput = scalpelOutput)

#example with optional parameters:
#plot only two of the neurons and add a title
plotTemporal(scalpelOutput = scalpelOutput, neuronsToDisplay = c(1,2),
             title = "First two neurons")
}
}
\seealso{
\code{\link{scalpelStep3}}, \code{\link{scalpel}}, \code{\link{plotResults}}
}
