% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocorr.R
\name{autocorr}
\alias{autocorr}
\title{Autocorrelation for single-case data}
\usage{
autocorr(data, dvar, pvar, mvar, lag_max = 3, lag.max, ...)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{lag_max, lag.max}{The lag up to which autocorrelations will be computed.}

\item{...}{Further arguments passed to the \code{\link[=acf]{acf()}} function}
}
\value{
A data frame containing separate autocorrelations for each phase and
for all phases (for each single-case). If \code{lag_max} exceeds the length
of a phase minus one, NA is returned for this cell.
}
\description{
The autocorr function calculates autocorrelations within each phase and
across all phases.
}
\examples{
## Compute autocorrelations for a list of four single-cases up to lag 2.
autocorr(Huber2014, lag_max = 2)
}
\seealso{
\code{\link[=acf]{acf()}}

Other regression functions: 
\code{\link{corrected_tau}()},
\code{\link{hplm}()},
\code{\link{mplm}()},
\code{\link{plm}()},
\code{\link{trend}()}
}
\author{
Juergen Wilbert
}
\concept{Autocorrelation}
\concept{Serial correlation}
\concept{regression functions}
\keyword{regression}
