% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fss_utility_functions.R
\name{apply_rowwise}
\alias{apply_rowwise}
\title{Apply a function to each row of a matrix.}
\usage{
apply_rowwise(A, .f, ...)
}
\arguments{
\item{A}{A matrix.}

\item{.f}{A function taking a vector as a first argument. This function 
should preferably return a vector of the same length as the first 
argument.}

\item{...}{Other arguments passed to \code{.f}.}
}
\value{
In case \code{.f} returns a vector of length \code{n}, a matrix with
   \code{nrow(A)} rows and \code{n} columns is returned. If \code{.f} returns
   a scalar, a vector with \code{nrow(A)} elements is returned.
}
\description{
Apply a function to each row of a matrix. If the function returns a scalar,
then return a vector. If the function returns a vector, return a matrix with
the same number of rows.
}
\keyword{internal}
