% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatteR.R
\name{scatteR}
\alias{scatteR}
\title{Generate scatterplots based on the scagnostics measurement}
\usage{
scatteR(
  measurements = c(Monotonic = 1, Outlying = 0.5),
  n_points = 50,
  init_points = NULL,
  global_min = 0.001,
  error_var = 0.001,
  epochs = 100,
  seed = 1835,
  verbose = TRUE,
  loss = "mae",
  ...
)
}
\arguments{
\item{measurements}{A named vector containing the scagnostic measurements that the resulting scatterplot should have}

\item{n_points}{The number of points that the resulting scatterplot should have.}

\item{init_points}{The number of initial points to use to build the iterative scatterplots. Default is NULL in which case the factors of n_points will be calculated and the 25th quantile from the set of factors will be used.}

\item{global_min}{the error that the resulting scagnostics can give}

\item{error_var}{the variance of the random error that is added on to the existing points}

\item{epochs}{number of epochs the optimization method should run}

\item{seed}{The random number generation seed}

\item{verbose}{Logical. TRUE means that messages from the optimization algorithm are shown. Default is TRUE}

\item{loss}{The loss function to be used within the scatteR program. Can be either 'mae' or 'mse'. Default is 'mae'}

\item{...}{Extra arguments to be used in the control argument of the GenSA function of the GenSA package}
}
\value{
A bivariate data.frame with two columns named x and y that gives a roughly similar scagnostic measurement to the `measurements` argument
}
\description{
Generate scatterplots based on the scagnostics measurement
}
