% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risetime.R
\name{risetime.correct_gaussian}
\alias{risetime.correct_gaussian}
\title{Undo the effect of the gaussian filter.}
\usage{
risetime.correct_gaussian(Tr, segments, units = "s")
}
\arguments{
\item{Tr}{Rise time of the filter in (us)}

\item{segments}{A segment or multiple segments with $states and $dwells to correct.}

\item{units}{What unit the risetime is input in (defaults to seconds)}
}
\value{
A Segment or multiple segments with corrected risetimes.
}
\description{
Undo the effect of the gaussian filter. See section 4.1.1 of Colquhoun and Sigworth, "Fitting and Analysis of Single-Channel segments". NOTE: This is potentially problematic, in that this unfiltering lengthens every dwell. A less naive algorithm would take into account the infulence of the surroundings, as they impact the effects of the filter.
}
\examples{

infile <- system.file("extdata", "example1_tac.evt", package = "scbursts")
transitions <- evt.read(infile)
dwells <- evt.to_dwells(transitions)

dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")

}
