% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_plot_cbar.R
\name{scf_plot_cbar}
\alias{scf_plot_cbar}
\title{Bar Plot of Summary Statistics by Grouping Variable in SCF Data}
\usage{
scf_plot_cbar(
  design,
  yvar,
  xvar,
  stat = "mean",
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  fill = "#0072B2",
  angle = 30,
  label_map = NULL
)
}
\arguments{
\item{design}{A \code{scf_mi_survey} object from \code{\link[=scf_load]{scf_load()}}.}

\item{yvar}{One-sided formula for the continuous variable (e.g., \code{~networth}).}

\item{xvar}{One-sided formula for the grouping variable (e.g., \code{~racecl}).}

\item{stat}{\code{"mean"} (default), \code{"median"}, or a quantile (numeric between 0 and 1).}

\item{title}{Plot title (optional).}

\item{xlab}{X-axis label (optional).}

\item{ylab}{Y-axis label (optional).}

\item{fill}{Bar fill color. Default is \code{"#0072B2"}.}

\item{angle}{Angle of x-axis labels. Default is 30.}

\item{label_map}{Optional named vector to relabel x-axis category labels.}
}
\value{
A \code{ggplot2} object.
}
\description{
Computes and plots a grouped summary statistic (either a mean, median, or
quantile) for a continuous variable across a discrete factor. Estimates are
pooled across implicates using \code{\link[=scf_mean]{scf_mean()}}, \code{\link[=scf_median]{scf_median()}}, or
\code{\link[=scf_percentile]{scf_percentile()}}. Use this function to visualize the bivariate relationship
between a discrete and a continuous variable.
}
\section{Implementation}{

The user specifies a continuous outcome (\code{yvar}) and a discrete grouping
variable (\code{xvar}) via one-sided formulas. Group means are plotted by default.
Medians or other percentiles can be specified via the \code{stat} argument.

Results are plotted using \code{ggplot2::geom_col()}, styled with \code{\link[=scf_theme]{scf_theme()}},
and optionally customized with additional arguments (e.g., axis labels,
color, angles).
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Plot mean net worth by education level
scf_plot_cbar(scf2022, ~networth, ~edcl, stat = "mean")

# Example for real analysis: Visualize 90th percentile of income by education
scf_plot_cbar(scf2022, ~income, ~edcl, stat = 0.9, fill = "#D55E00")

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)

}
\seealso{
\code{\link[=scf_mean]{scf_mean()}}, \code{\link[=scf_median]{scf_median()}}, \code{\link[=scf_percentile]{scf_percentile()}}, \code{\link[=scf_theme]{scf_theme()}}
}
