% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastq.R
\name{DownloadSRA}
\alias{DownloadSRA}
\title{Download SRA.}
\usage{
DownloadSRA(
  gsm.df,
  prefetch.path = NULL,
  out.folder = NULL,
  prefetch.paras = "-X 100G"
)
}
\arguments{
\item{gsm.df}{Dataframe contains GSM and Run numbers, obtained from \code{ExtractRun}.}

\item{prefetch.path}{Path to prefetch. Default: NULL (conduct automatic detection).}

\item{out.folder}{Output folder. Default: NULL (current working directory).}

\item{prefetch.paras}{Parameters for \code{prefetch}. Default: "-X 100G".}
}
\value{
Dataframe contains failed runs or NULL.
}
\description{
Download SRA.
}
\examples{
\dontrun{
# need users to provide the prefetch.path and out.folder
GSE186003.runs <- ExtractRun(acce = "GSE186003", platform = "GPL24247")
GSE186003.down <- DownloadSRA(
  gsm.df = GSE186003.runs, prefetch.path = "/path/to/prefetch",
  out.folder = "/path/to/output"
)
}
}
