% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{scidb_prefix}
\alias{scidb_prefix}
\title{Register an AFL prefix expression}
\usage{
scidb_prefix(db, expression = NULL)
}
\arguments{
\item{db}{a scidb database connection returned from \code{\link{scidbconnect}}}

\item{expression}{a valid AFL expression to be issued prior to, and in the same context as all subsequent
query expressions issued to the database corresponding to \code{db}. Set \code{expression=NULL} to remove the prefix expression.}
}
\value{
A new SciDB database connection object with the prefix set.
}
\description{
SciDB AFL statements are normally executed in a stateless query context.
Use scidb_prefix to create compound AFL expressions useful in some
circumstances.
}
\note{
This is mostly useful for setting namespaces, see the examples.
}
\examples{
\dontrun{
library(scidb)
db <- scidbconnect()
ls(db)
new_db <- scidb_prefix(db, "set_role('functionary')")
ls(new_db)
}
}

