% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.sclr}
\alias{predict.sclr}
\title{Predict method for scaled logit model x.}
\usage{
\method{predict}{sclr}(object, newdata, ci_lvl = 0.95, ...)
}
\arguments{
\item{object}{Object returned by \code{\link{sclr}}.}

\item{newdata}{A dataframe with all covariates. Names should be as they
appear in the formula in the call to \code{\link{sclr}}.}

\item{ci_lvl}{Confidence level for the calculated interval.}

\item{...}{Not used. Needed to match generic signature.}
}
\value{
A \code{\link[tibble]{tibble}} obtained by adding the following
columns to \code{newdata}:
\item{prot_point_lin prot_l_lin prot_u_lin}{Point estimate, low and high 
bounds of the linear transformation.}
\item{prot_sd_lin}{Estimated standard deviation of the linear 
transformation.}
\item{prot_point prot_l prot_u}{Inverse logit-transformed 
point estimate, low and high bounds of the linear transformation.}
}
\description{
Returns only the protection estimates. The only supported interval is
a confidence interval (i.e. the interval for the estimated expected value).
}
\details{
The model is \deqn{P(Y = 1) = \lambda(1 - logit^{-1}(\beta_0 +
\beta_1X_1 + \beta_2X_2 + ... + \beta_kX_k))} Where \eqn{Y} is the binary
outcome indicator, (e.g. 1 - infected, 0 - not infected). \eqn{X} - 
covariate.
\eqn{k} - number of covariates.
This function calculates \deqn{\beta_0 + \beta_1X_1 + \beta_2X_2 + ..
. + \beta_kX_k} transformations at the covariate values found in 
\code{newdata} as well as the variance-covariance matrices of those
transformations. This is used to calculate the confidence intervals at the
given parameter values. The inverse logit transformation is then applied
to point estimates and interval bounds.
}
