% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{qqplotGaussian}
\alias{qqplotGaussian}
\title{Gaussian distribution quantile-quantile plot}
\usage{
qqplotGaussian(data, ...)
}
\arguments{
\item{data}{List of data points to check}

\item{...}{The plot is created using \code{ggplot2}. This special parameter can be used to pass additional parameters to the \code{\link{geom_point}} function used to plot the sample points.}
}
\value{
A \code{\link{ggplot}} object.
}
\description{
This function creates a quantile-quantile plot to assess the goodness of fit of a Gaussian distribution to a given sample.
}
\examples{
## Skewed distribution
sample <- rbeta(100 , 2 , 50)
qqplotGaussian(sample)
## Symmetric distribution
sample <- rbeta(100 , 5 , 5)
qqplotGaussian(sample)
}
\seealso{
\code{\link{plotDensities}}
}

