% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_norm.R
\name{scores_norm}
\alias{scores_norm}
\alias{crps_norm}
\alias{crps_cnorm}
\alias{crps_tnorm}
\alias{crps_gtcnorm}
\alias{logs_norm}
\alias{logs_tnorm}
\alias{gradcrps_norm}
\alias{gradcrps_cnorm}
\alias{gradcrps_tnorm}
\alias{hesscrps_norm}
\alias{hesscrps_cnorm}
\alias{hesscrps_tnorm}
\title{Calculating scores for the normal distribution}
\usage{
## score functions
crps_norm(y, mean = 0, sd = 1, location = mean, scale = sd)
crps_cnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
crps_tnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
crps_gtcnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf, lmass = 0, umass = 0)
logs_norm(y, mean = 0, sd = 1, location = mean, scale = sd)
logs_tnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)

## gradient (location, scale) functions
gradcrps_norm(y, location = 0, scale = 1)
gradcrps_cnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
gradcrps_tnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)

## Hessian (location, scale) functions
hesscrps_norm(y, location = 0, scale = 1)
hesscrps_cnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
hesscrps_tnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
}
\arguments{
\item{y}{vector of observations.}

\item{mean}{an alternative way to specify \code{location}.}

\item{sd}{an alternative way to specify \code{scale}.}

\item{location}{vector of location parameters.}

\item{scale}{vector of scale parameters.}

\item{lower, upper}{lower and upper truncation/censoring bounds.}

\item{lmass, umass}{vectors of point masses in \code{lower} and \code{upper}
respectively.}
}
\value{
For the score functions: a vector of score values.

For the gradient and Hessian functions: a matrix with column names
corresponding to the respective partial derivatives.
}
\description{
These functions calculate scores (CRPS, logarithmic score) and their gradient and Hessian with respect
to the parameters of a location-scale transformed normal
distribution. Furthermore, the censoring transformation and
the truncation transformation may be introduced on top of the
location-scale transformed normal distribution.
}
