% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzyAugmentation.R
\name{fuzzy_augmentation}
\alias{fuzzy_augmentation}
\title{Fuzzy Augmentation}
\usage{
fuzzy_augmentation(xf, xnf, yf)
}
\arguments{
\item{xf}{The matrix of financed clients' characteristics to be used in the scorecard.}

\item{xnf}{The matrix of not financed clients' characteristics to be used in the scorecard (must be the same in the same order as xf!).}

\item{yf}{The matrix of financed clients' labels}
}
\value{
List containing the model using financed clients only and the model produced using the Fuzzy Augmentation method.
}
\description{
This function performs Reject Inference using the Fuzzy Augmentation technique. Note that this technique has no theoretical foundation and should produce (under the identifiability assumption) the same parameters' estimates than the financed clients scorecard.
}
\details{
This function performs the Fuzzy Augmentation method on the data. When provided with labeled observations \eqn{(x^\ell,y)}, it first fits the logistic regression model \eqn{p_\theta} of
\eqn{x^\ell} on \eqn{y}, then labels the unlabelled samples \eqn{x^{u}} with the predicted probabilities of \eqn{p_\theta}, i.e. \eqn{\hat{y}^{u} = p_\theta(y|x^{u})}
then refits a logistic regression model \eqn{p_\eta} on the whole sample.
}
\examples{
# We simulate data from financed clients
df <- generate_data(n = 100, d = 2)
xf <- df[, -ncol(df)]
yf <- df$y
# We simulate data from not financed clients (MCAR mechanism)
xnf <- generate_data(n = 100, d = 2)[, -ncol(df)]
fuzzy_augmentation(xf, xnf, yf)
}
\references{
Enea, M. (2015), speedglm: Fitting Linear and Generalized Linear Models to Large Data Sets, \url{https://CRAN.R-project.org/package=speedglm}
Ehrhardt, A., Biernacki, C., Vandewalle, V., Heinrich, P. and Beben, S. (2018), Reject Inference Methods in Credit Scoring: a rational review,
}
\seealso{
\code{glm}, \code{speedglm}
}
\author{
Adrien Ehrhardt
}
\keyword{credit}
\keyword{inference}
\keyword{reject}
\keyword{réintégration}
\keyword{scorecard}
\keyword{scoring}
