% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_binary.R
\name{score_binary}
\alias{score_binary}
\title{Evaluate forecasts in a Binary Format}
\usage{
score_binary(data, forecast_unit, metrics)
}
\arguments{
\item{data}{A data.frame or data.table with the predictions and observations.
For examples, look at the \link{example_quantile}, \link{example_continuous},
\link{example_integer}, and \link{example_binary} data sets.
For scoring using \code{\link[=score]{score()}}, the following columns need to be present:
\itemize{
\item \code{true_value} - the true observed values
\item \code{prediction} - predictions or predictive samples for one
true value. (You only don't need to provide a prediction column if
you want to score quantile forecasts in a wide range format.)}
For scoring integer and continuous forecasts a \code{sample} column is needed:
\itemize{
\item \code{sample} - an index to identify the predictive samples in the
prediction column generated by one model for one true value. Only
necessary for continuous and integer forecasts, not for
binary predictions.}
For scoring predictions in a quantile-format forecast you should provide
a column called \code{quantile}:
\itemize{
\item \code{quantile}: quantile to which the prediction corresponds
}}

\item{forecast_unit}{A character vector with the column names that define
the unit of a single forecast, i.e. a forecast was made for a combination
of the values in \code{forecast_unit}.}

\item{metrics}{the metrics you want to have in the output. If \code{NULL} (the
default), all available metrics will be computed. For a list of available
metrics see \code{\link[=available_metrics]{available_metrics()}}, or check the \link{metrics} data set.}
}
\value{
A data.table with appropriate scores. For more information see
\code{\link[=score]{score()}}.
}
\description{
Evaluate forecasts in a Binary Format
}
\author{
Nikos Bosse \email{nikosbosse@gmail.com}
}
\keyword{internal}
