% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast-nominal.R
\name{get_metrics.forecast_nominal}
\alias{get_metrics.forecast_nominal}
\title{Get default metrics for nominal forecasts}
\usage{
\method{get_metrics}{forecast_nominal}(x, select = NULL, exclude = NULL, ...)
}
\arguments{
\item{x}{A forecast object (a validated data.table with predicted and
observed values, see \code{\link[=as_forecast_binary]{as_forecast_binary()}}).}

\item{select}{A character vector of scoring rules to select from the list. If
\code{select} is \code{NULL} (the default), all possible scoring rules are returned.}

\item{exclude}{A character vector of scoring rules to exclude from the list.
If \code{select} is not \code{NULL}, this argument is ignored.}

\item{...}{unused}
}
\description{
For nominal forecasts, the default scoring rule is:
\itemize{
\item "log_score" = \code{\link[=logs_categorical]{logs_categorical()}}
}
}
\examples{
get_metrics(example_nominal)
}
\seealso{
Other get_metrics functions: 
\code{\link{get_metrics}()},
\code{\link{get_metrics.forecast_binary}()},
\code{\link{get_metrics.forecast_ordinal}()},
\code{\link{get_metrics.forecast_point}()},
\code{\link{get_metrics.forecast_quantile}()},
\code{\link{get_metrics.forecast_sample}()},
\code{\link{get_metrics.scores}()}
}
\concept{get_metrics functions}
\keyword{handle-metrics}
