% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scphaser.R
\name{filter_var_gt}
\alias{filter_var_gt}
\title{Filter variants}
\usage{
filter_var_gt(acset, nmincells = 3)
}
\arguments{
\item{acset}{An acset list created by \code{\link{new_acset}}. It must
contain a "gt" element with transcribed genotype calls, see
\code{\link{call_gt}}.}

\item{nmincells}{An integer specifying the minimum number of cells with
imbalanced allelic expression.}
}
\value{
acset An acset list subsetted on variants that pass the filter.
}
\description{
\code{filter_var_gt} removes variants based on the number of cells with
imbalanced expression
}
\details{
The function removes variants which have less than "nmincells" cells with
imbalanced allelic expression. A cell is deemed to have imbalanced allelic
expression if its transcribed genotype is set to 0 or 2, see
\code{\link{call_gt}}.
}
\examples{
##create a small artificial genotype matrix
ncells = 10
paternal = c(0, 2, 0, 0, 2)
maternal = c(2, 0, 2, 2, 0)
gt = as.matrix(as.data.frame(rep(list(paternal, maternal), ncells / 2)))
vars = 1:nrow(gt)
colnames(gt) = 1:ncells
rownames(gt) = vars

##create a feature annotation data-frame
nvars = nrow(gt)
featdata = as.data.frame(matrix(cbind(rep('jfeat', nvars),
as.character(1:nvars), rep('dummy', nvars), rep('dummy', nvars)), ncol = 4,
dimnames = list(vars, c('feat', 'var', 'ref', 'alt'))), stringsAsFactors =
FALSE)

##create acset
acset = new_acset(featdata, gt = gt)

##Remove variants with imbalanced expression in less than 3 cells
nmincells = 3
acset_filt = filter_var_gt(acset, nmincells)

}

