% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scpi-package.R
\docType{package}
\name{scpi-package}
\alias{scpi-package}
\alias{_PACKAGE}
\title{scpi: A package to compute Synthetic Control Prediction Intervals}
\description{
The package implements estimation, inference procedures, and produce plots for Synthetic Control (SC) methods using least square, lasso, ridge, or simplex-type
constraints according to \href{https://cattaneo.princeton.edu/papers/Cattaneo-Feng-Titiunik_2021_JASA.pdf}{Cattaneo, M. D., Feng, Y., & Titiunik, R. (2021)}.

Included functions are: \link{scdata} for data preparation, \link{scest} for point estimation, \link{scpi} for inference procedures, and \link{scplot} for plots.

\code{print()} and \code{summary()} methods are available for \code{\link{scest}} and \code{\link{scpi}}.

Companion \href{https://www.stata.com/}{Stata} and \href{https://www.python.org/}{Python} packages are described in \href{https://arxiv.org/abs/2202.05984}{Cattaneo, Feng, Palomba, and Titiunik (2022)}.

Related Stata, R, and Python packages useful for inference in SC designs are described in the following website:

\href{ https://nppackages.github.io/scpi/}{ https://nppackages.github.io/scpi/}

For an introduction to synthetic control methods, see \href{https://economics.mit.edu/files/17847}{Abadie (2021)} and references therein.
}
\references{
\itemize{
\item{\href{https://economics.mit.edu/files/17847}{Abadie, A. (2021)}. Using synthetic controls: Feasibility, data requirements, and methodological aspects.
\emph{Journal of Economic Literature}, 59(2), 391-425.}
\item{\href{https://cattaneo.princeton.edu/papers/Cattaneo-Feng-Titiunik_2021_JASA.pdf}{Cattaneo, M. D., Feng, Y., & Titiunik, R.
(2021)}. Prediction intervals for synthetic control methods. \emph{Journal of the American Statistical Association}, 116(536), 1865-1880.}
\item{\href{https://arxiv.org/abs/2202.05984}{Cattaneo, M. D., Feng, Y., Palomba F., and Titiunik, R. (2022).}
scpi: Uncertainty Quantification for Synthetic Control Estimators, \emph{arXiv}:2202.05984.}
}
}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Yingjie Feng, Tsinghua University. \email{fengyj@sem.tsinghua.edu.cn}.

Filippo Palomba, Princeton University (maintainer). \email{fpalomba@princeton.edu}.

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}.
}
