% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclustDepart.R
\name{sigp}
\alias{sigp}
\title{Significance for first split using sigclust2}
\usage{
sigp(test_dat, minSize = 10, sim = 100)
}
\arguments{
\item{test_dat}{A UMI count data matrix with samples to cluster as rows and features as columns.}

\item{minSize}{A numeric value specifying the minimal allowable cluster size (the number of cells for the smallest cluster, default 10).}

\item{sim}{A numeric value specifying the number of simulations during the Monte Carlo simulation procedure (default 100).}
}
\value{
A list with the following elements:
\itemize{
\item{\code{p}}: {p-value for the first split}
\item{\code{z}}: {z-score for the first split}
\item{\code{shc_result}}: {a \code{shc} S3-object as defined in sigclust2 package}
\item{\code{clust2}}: {a vector with group index for each cell}
\item{\code{clust_dat}}: {a matrix of data representation used as input for hierarchical clustering}
}
}
\description{
This function returns a list with elements mainly generated from sigclust2.
}
\details{
This is a function used to calculate the significance level of the first split from hierarchical clustering
based on euclidean distance and Ward's linkage.
}
\references{
\insertRef{kimes2017statistical}{scpoisson}
\insertRef{Rclusterpp}{scpoisson}
}
