% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecoregion.R
\name{eco_region}
\alias{eco_region}
\alias{regions_meow}
\alias{regions_fao}
\title{Filter points within ecoregions}
\usage{
eco_region(x, dataset = "meow", region, lat = NULL, lon = NULL, drop = TRUE)

regions_meow()

regions_fao()
}
\arguments{
\item{x}{(data.frame) A data.frame}

\item{dataset}{(character) the dataset to use. one of: "meow" (Marine
Ecoregions of the World), "fao" (). See Details.}

\item{region}{(character) the region name. has the form \code{a:b} where
\code{a} is a variable name (column in the sf object) and \code{b} is the value you want
to filter to within that variable. See Details.}

\item{lat, lon}{(character) name of the latitude and longitude column to use}

\item{drop}{(logical) Drop bad data points or not. Either way, we parse out
bad data points as an attribute you can access. Default: \code{TRUE}
#param ignore.na (logical) To consider NA values as a bad point or not.
Default: \code{FALSE}}
}
\value{
Returns a data.frame, with attributes
}
\description{
Filter points within ecoregions
}
\details{
see \code{scrubr_cache} for managing the cache of data
}
\section{dataset options}{

\itemize{
\item Marine Ecoregions of the World (meow):
\itemize{
\item data from: https://opendata.arcgis.com/datasets/ed2be4cf8b7a451f84fd093c2e7660e3_0.geojson
}
\item Food and Agriculture Organization (fao):
\itemize{
\item data from: http://www.fao.org/geonetwork/srv/en/main.home?uuid=ac02a460-da52-11dc-9d70-0017f293bd28
}
}
}

\section{region options}{

\itemize{
\item within meow:
\itemize{
\item ECOREGION: many options, see \code{regions_meow()}
\item ECO_CODE: many options, see \code{regions_meow()}
\item and you can use others as well; run \code{regions_meow()} to get the data used
within \code{eco_region()} and see what variables/columns can be used
}
\item within fao:
\itemize{
\item OCEAN: Atlantic, Pacific, Indian, Arctic
\item SUBOCEAN: 1 through 11 (inclusive)
\item F_AREA (fishing area): 18, 21, 27, 31, 34, 37, 41, 47, 48, 51, 57, 58,
61, 67, 71, 77, 81, 87, 88
\item and you can use others as well; run \code{regions_fao()} to get the data used
within \code{eco_region()} and see what variables/columns can be used
}
}
}

\examples{
\dontrun{
if (requireNamespace("mapview") && requireNamespace("sf")) {
## Marine Ecoregions of the World
wkt <- 'POLYGON((-119.8 12.2, -105.1 11.5, -106.1 21.6, -119.8 20.9, -119.8 12.2))'
res <- rgbif::occ_data(geometry = wkt, limit=300)$data
res2 <- sf::st_as_sf(res, coords = c("decimalLongitude", "decimalLatitude"))
res2 <- sf::st_set_crs(res2, 4326)
mapview::mapview(res2)
tmp <- eco_region(dframe(res), dataset = "meow",
   region = "ECOREGION:Mexican Tropical Pacific")
tmp2 <- sf::st_as_sf(tmp, coords = c("decimalLongitude", "decimalLatitude"))
tmp2 <- sf::st_set_crs(tmp2, 4326)
mapview::mapview(tmp2)

## FAO
wkt <- 'POLYGON((72.2 38.5,-173.6 38.5,-173.6 -41.5,72.2 -41.5,72.2 38.5))'
manta_ray <- rgbif::name_backbone("Mobula alfredi")$usageKey
res <- rgbif::occ_data(manta_ray, geometry = wkt, limit=300, hasCoordinate = TRUE)
dat <- sf::st_as_sf(res$data, coords = c("decimalLongitude", "decimalLatitude"))
dat <- sf::st_set_crs(dat, 4326)
mapview::mapview(dat)
tmp <- eco_region(dframe(res$data), dataset = "fao", region = "OCEAN:Indian")
tmp <- tmp[!is.na(tmp$decimalLongitude), ]
tmp2 <- sf::st_as_sf(tmp, coords = c("decimalLongitude", "decimalLatitude"))
tmp2 <- sf::st_set_crs(tmp2, 4326)
mapview::mapview(tmp2)
}}
}
