% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insightmaker_conv.R
\name{url_to_IM}
\alias{url_to_IM}
\title{Extract Insight Maker model from URL}
\usage{
url_to_IM(URL, file = NULL)
}
\arguments{
\item{URL}{String with URL to an Insight Maker model}

\item{file}{If specified, file path to save Insight Maker model to. If NULL, do not save model.}
}
\value{
XML string with Insight Maker model
}
\description{
Create XML string from Insight Maker URL. For internal use; use \code{insightmaker_to_sfm()} to import an Insight Maker model.
}
\examples{
\dontshow{if (has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
xml <- url_to_IM(
  URL =
    "https://insightmaker.com/insight/43tz1nvUgbIiIOGSGtzIzj/Romeo-Juliet"
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=insightmaker_to_sfm]{insightmaker_to_sfm()}}
}
\concept{insightmaker}
