% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drifts.R
\name{driftJp}
\alias{driftJp}
\title{Drift for the JP diffusion}
\usage{
driftJp(x, alpha, mu, psi)
}
\arguments{
\item{x}{vector with the evaluation points for the drift.}

\item{alpha}{strength of the drift.}

\item{mu}{unconditional mean of the diffusion.}

\item{psi}{shape parameter, see details.}
}
\value{
A vector of the same length as \code{x} containing the drift.
}
\description{
Drift for the Langevin diffusion associated to the Jones and Pewsey (JP) family of circular distributions.
}
\details{
Particular interesting choices for the shape parameter are:
\itemize{
\item \code{psi = -1}: gives the Wrapped Cauchy as stationary density.
\item \code{psi = 0}: is the sinusoidal drift of the vM diffusion.
\item \code{psi = 1}: gives the Cardioid as stationary density.
}
See Section 2.2.3 in García-Portugués et al. (2019) for details.
}
\examples{
x <- seq(-pi, pi, l = 200)
plot(x, x, type = "n", ylab = "drift")
for (i in 0:20) {
  lines(x, driftJp(x = x, alpha = 1, mu = 0, psi = -1 + 2 * i / 20),
        col = rainbow(21)[i + 1])
}
}
\references{
García-Portugués, E., Sørensen, M., Mardia, K. V. and Hamelryck, T. (2019) Langevin diffusions on the torus: estimation and applications. \emph{Statistics and Computing}, 29(2):1--22. \url{https://doi.org/10.1007/s11222-017-9790-2}

Jammalamadaka, S. R. and SenGupta, A. (2001) \emph{Topics in Circular Statistics}. World Scientific, Singapore. \url{https://doi.org/10.1142/4031}

Jones, M. C. and Pewsey, A. (2005). A family of symmetric distributions on the circle. \emph{Journal of the American Statistical Association}, 100(472):1422--1428. \url{https://doi.org/10.1198/016214505000000286}
}
