% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlso.R
\name{dlso}
\alias{dlso}
\title{Perform Draws-Based Latent Structure Optimization}
\usage{
dlso(x, loss = c("squaredError", "absoluteError", "binder",
  "lowerBoundVariationOfInformation")[1], multicore = TRUE,
  expectedPairwiseAllocationMatrix = NULL)
}
\arguments{
\item{x}{A
collection of clusterings as a
\code{B}-by-\code{n} matrix, each of the \code{B} rows represents a
clustering of \code{n} items using cluster labels.  For clustering
\code{b}, items \code{i} and \code{j} are in the same cluster if
\code{x[b,i] == x[b,j]}.}

\item{loss}{One of \code{"squaredError"}, \code{"absoluteError"}, \code{"binder"}, or
\code{"lowerBoundVariationOfInformation"} to indicate the optimization should seeks to
minimize expectation of the squared error loss, absolute error loss, Binder loss (Binder 1978), or the lower
bound of the variation of information loss (Wade & Ghahramani 2017), respectively.
The first three are equivalent.}

\item{multicore}{Logical indicating whether computations should take advantage of
multiple CPU cores.}

\item{expectedPairwiseAllocationMatrix}{A \code{n}-by-\code{n} symmetric matrix
whose \code{(i,j)} elements gives the estimated expected number of times that items
\code{i} and \code{j} are in the same subset (i.e., cluster).  If \code{NULL},
it is computed from \code{x}.}
}
\value{
A list A clustering (as a vector of cluster labels).
}
\description{
Among the supplied latent structures, this function picks the structure that minimizes
one of various loss functions.
}
\examples{
suppressWarnings({  # For testing purposes, suppress deprecation warning.

dlso(iris.clusterings)

})

}
\references{
Wade, S. and Ghahramani, Z. (2017). Bayesian cluster analysis: Point estimation and credible balls. Bayesian analysis.

Binder, D. (1978). Bayesian Cluster Analysis. Biometrika, 65: 31–38.
}
\seealso{
\code{\link{expectedPairwiseAllocationMatrix}}, \code{\link{salso}}
}
\author{
David B. Dahl \email{dahl@stat.byu.edu}
}
