% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwd.R
\name{dwd}
\alias{dwd}
\title{Distance Weighted Discrimination}
\usage{
dwd(Ap, An, penalty)
}
\arguments{
\item{Ap}{An nxp point configuration matrix}

\item{An}{An nxp point configuration matrix}

\item{penalty}{A real valued scalar penalty for moving points across classification rule}
}
\value{
\item{X}{A list containing the solution matrix to the primal problem}
\item{y}{A list containing the  solution vector to the dual problem}
\item{Z}{A list containing the  solution matrix to the dual problem}
\item{pobj}{The achieved value of the primary objective function}
\item{dobj}{The achieved value of the dual objective function}
}
\description{
\code{dwd} creates input for sqlp to solve the Distance Weighted Discrimination problem -
Given two sets of points An and Ap, find an optimal classification rule to group the points as accurately
as possible for future classification.
}
\details{
Solves the distance weighted discrimination problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(Andwd)
data(Apdwd)
penalty <- 0.5

#Not Run
#out <- dwd(Apdwd,Andwd,penalty)

}
