% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmi.R
\name{lmi2}
\alias{lmi2}
\title{Linear Matrix Inequality 2}
\usage{
lmi2(A1, A2, B)
}
\arguments{
\item{A1}{An nxm real valued matrix}

\item{A2}{An nxm real valued matrix}

\item{B}{An nxp real valued matrix}
}
\value{
\item{X}{A list containing the solution matrix to the primal problem}
\item{y}{A list containing the  solution vector to the dual problem}
\item{Z}{A list containing the  solution matrix to the dual problem}
\item{pobj}{The achieved value of the primary objective function}
\item{dobj}{The achieved value of the dual objective function}
}
\description{
\code{lmi2} creates input for sqlp to solve a linear matrix inequality problem
}
\details{
Solves the type-2 linear matrix inequality problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
A1 <- matrix(c(-1,0,1,0,-2,1,0,0,-1),3,3)
A2 <- A1 + 0.1*t(A1)
B  <- matrix(c(1,3,5,2,4,6),3,2)

out <- lmi2(A1,A2,B)

}
