% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf_helpers.R
\name{sf_gk_proj_cgcs2000}
\alias{sf_gk_proj_cgcs2000}
\title{generates cgcs2000 Gauss-Kruger projection epsg coding character}
\usage{
sf_gk_proj_cgcs2000(sfj, degree = 6L)
}
\arguments{
\item{sfj}{An \code{sf} object or can be converted to \code{sf} by \code{sf::st_as_sf()}.}

\item{degree}{(optional) \code{3}-degree or \code{6}-degree zonal projection, default is \code{6L}.}
}
\value{
A character.
}
\description{
Generates a Gauss-Kruger projection epsg coding character corresponding to an \code{sfj} object
under the CGCS2000 spatial reference.
}
\examples{
gzma = sf::read_sf(system.file('extdata/gzma.gpkg',package = 'sdsfun')) |>
  sf::st_transform(4490)
sf_gk_proj_cgcs2000(gzma,3)
sf_gk_proj_cgcs2000(gzma,6)

}
