\name{cv.sdwd}
\alias{cv.sdwd}
\title{cross-validation for the sparse DWD}
\description{Conducts a k-fold cross-validation for \code{\link{sdwd}} and returns the suggested values of the L1 parameter \code{lambda}.}
\usage{
cv.sdwd(x, y, lambda, nfolds, foldid, ...)
}
\arguments{
		\item{x}{A matrix of predictors, i.e., the \code{x} matrix used in \code{\link{sdwd}}.}
		\item{y}{A vector of binary class labels, i.e., the \code{y} used in \code{\link{sdwd}}.}
		\item{lambda}{Default is \code{NULL}, and the sequence generated by \code{\link{sdwd}} is used. User can also provide a new \code{lambda} sequence to use in cross-validation.}
		\item{nfolds}{The number of folds. Default value is 5. The allowable range is from 3 to the sample size. Larger \code{nfolds} needs more timing.}
		\item{foldid}{An optional vector with values between 1 and \code{nfold}, representing the folder indices for each observation.  
If supplied, \code{nfold} can be missing.}
		\item{\dots}{Other arguments that can be passed to sdwd.}

}
\details{This function runs \code{\link{sdwd}} to the sparse DWD by excluding every fold alternatively, and then computes the mean cross-validation error and the standard deviation. This function is modified based on the \code{cv} function from the \code{gcdnet} and the \code{glmnet} packages.
}
\value{A \code{\link{cv.sdwd}} object is returned, which includes the cross-validation fit.
		\item{lambda}{The \code{lambda} sequence used in \code{\link{sdwd}}.}
		\item{cvm}{A vector of length \code{length(lambda)} for the mean cross-validated error.}
		\item{cvsd}{A vector of length \code{length(lambda)} for estimates of standard error of \code{cvm}.}
		\item{cvupper}{The upper curve: \code{cvm + cvsd}.}
		\item{cvlower}{The lower curve: \code{cvm - cvsd}.}
		\item{nzero}{Numbers of non-zero coefficients at each \code{lambda}.}
		\item{name}{``Mis-classification error", for plotting purposes.}
		\item{sdwd.fit}{A fitted \code{\link{sdwd}} object using the full data.}
		\item{lambda.min}{The \code{lambda} incurring the minimum cross validation error \code{cvm}.}
		\item{lambda.1se}{The largest value of \code{lambda} such that error is within one standard error of the minimum.}
    \item{cv.min}{The minimum cross validation error.}
		\item{cv.1se}{The cross validation error associated with \code{lambda.1se}.}
}

\author{Boxiang Wang and Hui Zou\cr
Maintainer: Boxiang Wang  \email{boxiang@umn.edu}}
\references{Wang, B. and Zou, H. (2015)
  ``Sparse Distance Weighted Discrimination".%, \emph{University of Minnesoa Statistics Technical Report.}
  \cr
  \url{}\cr
Yang, Y. and Zou, H. (2013)
``An Efficient Algorithm for Computing the HHSVM and Its Generalizations", 
  \emph{Journal of Computational and Graphical Statistics}, \bold{22}(2), 396--415\cr
  \url{http://users.stat.umn.edu/~yiyang/resources/papers/JCGS_gcdnet.pdf}\cr
  
Friedman, J., Hastie, T., and Tibshirani, R. (2010), "Regularization paths for generalized
linear models via coordinate descent," \emph{Journal of Statistical Software}, \bold{33}(1), 1--22\cr
\url{http://www.jstatsoft.org/v33/i01/paper}
\cr

 }

\seealso{\code{\link{sdwd}}, \code{\link{plot.cv.sdwd}}, \code{\link{predict.cv.sdwd}}, and \code{\link{coef.cv.sdwd}} methods.}
\examples{
data(colon)
colon$x = colon$x[ ,1:100] # this example only uses the first 100 columns 
n = nrow(colon$x)
set.seed(1)
id = sample(n, trunc(n/3))
cvfit = cv.sdwd(colon$x[-id,], colon$y[-id], lambda2=1, nfolds=5)
plot(cvfit)
predict(cvfit, newx=colon$x[id,], s="lambda.min")
}
\keyword{models}
\keyword{regression}

