% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{delete_user}
\alias{delete_user}
\title{Delete a user.}
\usage{
delete_user(email, vault = NULL)
}
\arguments{
\item{email}{Email address of the user.}

\item{vault}{Vault location (starting point to find the vault).
To create a vault, use \code{\link[=create_vault]{create_vault()}} or \code{\link[=create_package_vault]{create_package_vault()}}.
If this is \code{NULL}, then \code{secret} tries to find the vault automatically:
\itemize{
\item If the \code{secret.vault} option is set to path, that is used as the
starting point.
\item Otherwise, if the \code{R_SECRET_VAULT} environment variable is set to a
path, that is used as a starting point.
\item Otherwise the current working directory is used as the starting
point.
}

If the starting point is a vault, that is used. Otherwise, if the
starting point is in a package tree, the \code{inst/vault} folder is used
within the package. If no vault can be found, an error is thrown.}
}
\description{
It also removes access of the user to all secrets, so if the user
is re-added again, they will not have access to any secrets.
}
\seealso{
Other user functions: \code{\link{add_github_user}},
  \code{\link{add_travis_user}}, \code{\link{add_user}},
  \code{\link{list_users}}
}
